/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence.spmm;

import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.query.DefaultQuery;
import java.util.Collection;
import net.automatalib.alphabet.ProceduralInputAlphabet;
import net.automatalib.automaton.procedural.SPMM;
import net.automatalib.util.automaton.procedural.SPMMs;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimulatorEQOracle<I, O>
implements EquivalenceOracle<SPMM<?, I, ?, O>, I, Word<O>> {
    private final SPMM<?, I, ?, O> spmm;

    public SimulatorEQOracle(SPMM<?, I, ?, O> spmm) {
        this.spmm = spmm;
    }

    public @Nullable DefaultQuery<I, Word<O>> findCounterExample(SPMM<?, I, ?, O> hypothesis, Collection<? extends I> inputs) {
        if (!(inputs instanceof ProceduralInputAlphabet)) {
            throw new IllegalArgumentException("Inputs are not an SPA alphabet");
        }
        ProceduralInputAlphabet alphabet = (ProceduralInputAlphabet)inputs;
        Word sep = SPMMs.findSeparatingWord(this.spmm, hypothesis, (ProceduralInputAlphabet)alphabet);
        if (sep == null) {
            return null;
        }
        return new DefaultQuery(sep, (Object)((Word)this.spmm.computeOutput((Iterable)sep)));
    }
}

