/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence.mealy;

import de.learnlib.logging.Category;
import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.sul.SUL;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.automatalib.automaton.transducer.MealyMachine;
import net.automatalib.common.util.collection.CollectionsUtil;
import net.automatalib.word.Word;
import net.automatalib.word.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomWalkEQOracle<I, O>
implements EquivalenceOracle.MealyEquivalenceOracle<I, O> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomWalkEQOracle.class);
    private final double restartProbability;
    private final long maxSteps;
    private final Random random;
    private final SUL<I, O> sul;
    private long steps;
    private boolean resetStepCount;

    public RandomWalkEQOracle(SUL<I, O> sul, double restartProbability, long maxSteps, boolean resetStepCount, Random random) {
        this(sul, restartProbability, maxSteps, random);
        this.resetStepCount = resetStepCount;
    }

    public RandomWalkEQOracle(SUL<I, O> sul, double restartProbability, long maxSteps, Random random) {
        this.restartProbability = restartProbability;
        this.maxSteps = maxSteps;
        this.random = random;
        this.sul = sul;
    }

    public @Nullable DefaultQuery<I, Word<O>> findCounterExample(MealyMachine<?, I, ?, O> hypothesis, Collection<? extends I> inputs) {
        return this.doFindCounterExample(hypothesis, inputs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <S, T> @Nullable DefaultQuery<I, Word<O>> doFindCounterExample(MealyMachine<S, I, T, O> hypothesis, Collection<? extends I> inputs) {
        if (this.resetStepCount) {
            this.steps = 0L;
        }
        if (inputs.isEmpty()) {
            LOGGER.warn(Category.COUNTEREXAMPLE, "Passed empty set of inputs to equivalence oracle; no counterexample can be found!");
            return null;
        }
        List choices = CollectionsUtil.randomAccessList(inputs);
        int bound = choices.size();
        Object cur = hypothesis.getInitialState();
        WordBuilder wbIn = new WordBuilder();
        WordBuilder wbOut = new WordBuilder();
        boolean first = true;
        this.sul.pre();
        try {
            while (this.steps < this.maxSteps) {
                if (first) {
                    first = false;
                } else {
                    double restart = this.random.nextDouble();
                    if (restart < this.restartProbability) {
                        this.sul.post();
                        this.sul.pre();
                        cur = hypothesis.getInitialState();
                        wbIn.clear();
                        wbOut.clear();
                        first = true;
                    }
                }
                ++this.steps;
                Object in = choices.get(this.random.nextInt(bound));
                Object outSul = this.sul.step(in);
                assert (cur != null);
                Object outHyp = hypothesis.getTransitionProperty(cur, in);
                wbIn.add(in);
                wbOut.add(outSul);
                if (!Objects.equals(outSul, outHyp)) {
                    DefaultQuery ce = new DefaultQuery(wbIn.toWord());
                    ce.answer((Object)wbOut.toWord());
                    DefaultQuery defaultQuery = ce;
                    return defaultQuery;
                }
                cur = hypothesis.getSuccessor(cur, in);
            }
            DefaultQuery<I, Word<O>> defaultQuery = null;
            return defaultQuery;
        }
        finally {
            this.sul.post();
        }
    }
}

