/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence;

import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.query.DefaultQuery;
import java.util.Collection;
import net.automatalib.automaton.UniversalDeterministicAutomaton;
import net.automatalib.automaton.concept.Output;
import net.automatalib.util.automaton.Automata;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimulatorEQOracle<A extends UniversalDeterministicAutomaton<?, I, ?, ?, ?>, I, D>
implements EquivalenceOracle<A, I, D> {
    private final UniversalDeterministicAutomaton<?, I, ?, ?, ?> reference;
    private final Output<I, D> output;

    public <R extends UniversalDeterministicAutomaton<?, I, ?, ?, ?> & Output<I, D>> SimulatorEQOracle(R reference) {
        this.reference = reference;
        this.output = reference;
    }

    public @Nullable DefaultQuery<I, D> findCounterExample(A hypothesis, Collection<? extends I> inputs) {
        Word sep = Automata.findSeparatingWord(this.reference, hypothesis, inputs);
        if (sep == null) {
            return null;
        }
        return new DefaultQuery(sep, this.output.computeOutput((Iterable)sep));
    }
}

