/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence;

import de.learnlib.oracle.EquivalenceOracle;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import de.learnlib.query.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import net.automatalib.automaton.concept.SuffixOutput;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SampleSetEQOracle<I, D>
implements EquivalenceOracle<SuffixOutput<I, D>, I, D> {
    private final boolean removeUnsuccessful;
    private final List<DefaultQuery<I, D>> testQueries;

    public SampleSetEQOracle(boolean removeUnsuccessful) {
        this.removeUnsuccessful = removeUnsuccessful;
        this.testQueries = !removeUnsuccessful ? new ArrayList<DefaultQuery<I, D>>() : new LinkedList<DefaultQuery<I, D>>();
    }

    public SampleSetEQOracle<I, D> add(Word<I> input, D expectedOutput) {
        this.testQueries.add(new DefaultQuery(input, expectedOutput));
        return this;
    }

    @SafeVarargs
    public final SampleSetEQOracle<I, D> addAll(MembershipOracle<I, D> oracle, Word<I> ... words) {
        return this.addAll(oracle, Arrays.asList(words));
    }

    public SampleSetEQOracle<I, D> addAll(MembershipOracle<I, D> oracle, Collection<? extends Word<I>> words) {
        if (words.isEmpty()) {
            return this;
        }
        ArrayList<DefaultQuery> newQueries = new ArrayList<DefaultQuery>(words.size());
        for (Word<I> w : words) {
            newQueries.add(new DefaultQuery(w));
        }
        oracle.processQueries(newQueries);
        this.testQueries.addAll(newQueries);
        return this;
    }

    @SafeVarargs
    public final SampleSetEQOracle<I, D> addAll(DefaultQuery<I, D> ... newTestQueries) {
        return this.addAll(Arrays.asList(newTestQueries));
    }

    public SampleSetEQOracle<I, D> addAll(Collection<? extends DefaultQuery<I, D>> newTestQueries) {
        this.testQueries.addAll(newTestQueries);
        return this;
    }

    public @Nullable DefaultQuery<I, D> findCounterExample(SuffixOutput<I, D> hypothesis, Collection<? extends I> inputs) {
        Iterator<DefaultQuery<I, D>> queryIt = this.testQueries.iterator();
        while (queryIt.hasNext()) {
            DefaultQuery<I, D> query = queryIt.next();
            if (!SampleSetEQOracle.checkInputs(query, inputs)) continue;
            if (!SampleSetEQOracle.test(query, hypothesis)) {
                return query;
            }
            if (!this.removeUnsuccessful) continue;
            queryIt.remove();
        }
        return null;
    }

    private static <I> boolean checkInputs(Query<I, ?> query, Collection<? extends I> inputs) {
        for (Object sym : query.getPrefix()) {
            if (inputs.contains(sym)) continue;
            return false;
        }
        for (Object sym : query.getSuffix()) {
            if (inputs.contains(sym)) continue;
            return false;
        }
        return true;
    }

    private static <I, D> boolean test(DefaultQuery<I, D> query, SuffixOutput<I, D> hypOutput) {
        Object hypOut = hypOutput.computeSuffixOutput((Iterable)query.getPrefix(), (Iterable)query.getSuffix());
        return Objects.equals(hypOut, query.getOutput());
    }
}

