/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence;

import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.api.query.DefaultQuery;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.words.Word;

public class EQOracleChain<A, I, D>
implements EquivalenceOracle<A, I, D> {
    private final List<EquivalenceOracle<? super A, I, D>> oracles;

    @SafeVarargs
    public EQOracleChain(EquivalenceOracle<? super A, I, D> ... oracles) {
        this(Arrays.asList(oracles));
    }

    public EQOracleChain(List<? extends EquivalenceOracle<? super A, I, D>> oracles) {
        this.oracles = new ArrayList<EquivalenceOracle<A, I, D>>(oracles);
    }

    public void addOracle(EquivalenceOracle<? super A, I, D> oracle) {
        this.oracles.add(oracle);
    }

    public DefaultQuery<I, D> findCounterExample(A hypothesis, Collection<? extends I> inputs) {
        for (EquivalenceOracle<? super A, I, D> equivalenceOracle : this.oracles) {
            DefaultQuery ceQry = equivalenceOracle.findCounterExample(hypothesis, inputs);
            if (ceQry == null) continue;
            return ceQry;
        }
        return null;
    }

    public static class MealyEQOracleChain<I, O>
    extends EQOracleChain<MealyMachine<?, I, ?, O>, I, Word<O>>
    implements EquivalenceOracle.MealyEquivalenceOracle<I, O> {
        @SafeVarargs
        public MealyEQOracleChain(EquivalenceOracle<? super MealyMachine<?, I, ?, O>, I, Word<O>> ... oracles) {
            super(oracles);
        }

        public MealyEQOracleChain(List<? extends EquivalenceOracle<? super MealyMachine<?, I, ?, O>, I, Word<O>>> oracles) {
            super(oracles);
        }
    }

    public static class DFAEQOracleChain<I>
    extends EQOracleChain<DFA<?, I>, I, Boolean>
    implements EquivalenceOracle.DFAEquivalenceOracle<I> {
        @SafeVarargs
        public DFAEQOracleChain(EquivalenceOracle<? super DFA<?, I>, I, Boolean> ... oracles) {
            super(oracles);
        }

        public DFAEQOracleChain(List<? extends EquivalenceOracle<? super DFA<?, I>, I, Boolean>> oracles) {
            super(oracles);
        }
    }
}

