/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence;

import com.google.common.collect.Lists;
import de.learnlib.api.oracle.BlackBoxOracle;
import de.learnlib.api.oracle.PropertyOracle;
import de.learnlib.api.query.DefaultQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.automatalib.automata.concepts.Output;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.words.Word;

public class DisproveFirstOracle<A extends Output<I, D>, I, D>
implements BlackBoxOracle<A, I, D> {
    private final List<PropertyOracle<I, ? super A, ?, D>> propertyOracles;

    public DisproveFirstOracle() {
        this(Collections.emptyList());
    }

    public DisproveFirstOracle(PropertyOracle<I, ? super A, ?, D> propertyOracle) {
        this(Lists.newArrayList((Object[])new PropertyOracle[]{propertyOracle}));
    }

    public DisproveFirstOracle(Collection<? extends PropertyOracle<I, ? super A, ?, D>> propertyOracles) {
        this.propertyOracles = new ArrayList(propertyOracles);
    }

    public List<PropertyOracle<I, ? super A, ?, D>> getPropertyOracles() {
        return this.propertyOracles;
    }

    @Nullable
    public DefaultQuery<I, D> findCounterExample(A hypothesis, Collection<? extends I> inputs) {
        for (PropertyOracle<I, ? super A, ?, D> propertyOracle : this.propertyOracles) {
            if (propertyOracle.isDisproved()) continue;
            propertyOracle.disprove(hypothesis, inputs);
        }
        for (PropertyOracle<I, ? super A, ?, D> propertyOracle : this.propertyOracles) {
            DefaultQuery ce;
            if (propertyOracle.isDisproved() || (ce = propertyOracle.doFindCounterExample(hypothesis, inputs)) == null) continue;
            assert (this.isCounterExample((Output)hypothesis, (Iterable)ce.getInput(), ce.getOutput()));
            return ce;
        }
        return null;
    }

    public static class MealyDisproveFirstOracle<I, O>
    extends DisproveFirstOracle<MealyMachine<?, I, ?, O>, I, Word<O>>
    implements BlackBoxOracle.MealyBlackBoxOracle<I, O> {
        public MealyDisproveFirstOracle() {
        }

        public MealyDisproveFirstOracle(PropertyOracle<I, ? super MealyMachine<?, I, ?, O>, ?, Word<O>> propertyOracle) {
            super(propertyOracle);
        }

        public MealyDisproveFirstOracle(Collection<? extends PropertyOracle<I, ? super MealyMachine<?, I, ?, O>, ?, Word<O>>> propertyOracles) {
            super(propertyOracles);
        }
    }

    public static class DFADisproveFirstOracle<I>
    extends DisproveFirstOracle<DFA<?, I>, I, Boolean>
    implements BlackBoxOracle.DFABlackBoxOracle<I> {
        public DFADisproveFirstOracle() {
        }

        public DFADisproveFirstOracle(PropertyOracle<I, ? super DFA<?, I>, ?, Boolean> propertyOracle) {
            super(propertyOracle);
        }

        public DFADisproveFirstOracle(Collection<? extends PropertyOracle<I, ? super DFA<?, I>, ?, Boolean>> propertyOracles) {
            super(propertyOracles);
        }
    }
}

