/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence;

import com.google.common.collect.Streams;
import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.oracle.equivalence.AbstractTestWordEQOracle;
import java.util.Collection;
import java.util.stream.Stream;
import net.automatalib.automata.concepts.Output;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transducers.MealyMachine;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.words.Word;

public class CompleteExplorationEQOracle<A extends Output<I, D>, I, D>
extends AbstractTestWordEQOracle<A, I, D> {
    private final int minDepth;
    private final int maxDepth;

    public CompleteExplorationEQOracle(MembershipOracle<I, D> sulOracle, int maxDepth) {
        this(sulOracle, 1, maxDepth);
    }

    public CompleteExplorationEQOracle(MembershipOracle<I, D> sulOracle, int minDepth, int maxDepth) {
        this(sulOracle, minDepth, maxDepth, 1);
    }

    public CompleteExplorationEQOracle(MembershipOracle<I, D> sulOracle, int minDepth, int maxDepth, int batchSize) {
        super(sulOracle, batchSize);
        this.minDepth = Math.min(minDepth, maxDepth);
        this.maxDepth = Math.max(minDepth, maxDepth);
    }

    @Override
    protected Stream<Word<I>> generateTestWords(A hypothesis, Collection<? extends I> inputs) {
        return Streams.stream((Iterable)CollectionsUtil.allTuples(inputs, (int)this.minDepth, (int)this.maxDepth)).map(Word::fromList);
    }

    public static class MealyCompleteExplorationEQOracle<I, O>
    extends CompleteExplorationEQOracle<MealyMachine<?, I, ?, O>, I, Word<O>>
    implements EquivalenceOracle.MealyEquivalenceOracle<I, O> {
        public MealyCompleteExplorationEQOracle(MembershipOracle<I, Word<O>> mqOracle, int maxDepth) {
            super(mqOracle, maxDepth);
        }

        public MealyCompleteExplorationEQOracle(MembershipOracle<I, Word<O>> mqOracle, int minDepth, int maxDepth) {
            super(mqOracle, minDepth, maxDepth);
        }

        public MealyCompleteExplorationEQOracle(MembershipOracle<I, Word<O>> mqOracle, int minDepth, int maxDepth, int batchSize) {
            super(mqOracle, minDepth, maxDepth, batchSize);
        }
    }

    public static class DFACompleteExplorationEQOracle<I>
    extends CompleteExplorationEQOracle<DFA<?, I>, I, Boolean>
    implements EquivalenceOracle.DFAEquivalenceOracle<I> {
        public DFACompleteExplorationEQOracle(MembershipOracle<I, Boolean> mqOracle, int maxDepth) {
            super(mqOracle, maxDepth);
        }

        public DFACompleteExplorationEQOracle(MembershipOracle<I, Boolean> mqOracle, int minDepth, int maxDepth) {
            super(mqOracle, minDepth, maxDepth);
        }

        public DFACompleteExplorationEQOracle(MembershipOracle<I, Boolean> mqOracle, int minDepth, int maxDepth, int batchSize) {
            super(mqOracle, minDepth, maxDepth, batchSize);
        }
    }
}

