/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Streams;
import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.DefaultQuery;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.automatalib.automata.concepts.Output;
import net.automatalib.words.Word;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTestWordEQOracle<A extends Output<I, D>, I, D>
implements EquivalenceOracle<A, I, D> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractTestWordEQOracle.class);
    private final MembershipOracle<I, D> membershipOracle;
    private final int batchSize;

    public AbstractTestWordEQOracle(MembershipOracle<I, D> membershipOracle) {
        this(membershipOracle, 1);
    }

    public AbstractTestWordEQOracle(MembershipOracle<I, D> membershipOracle, int batchSize) {
        Preconditions.checkArgument((batchSize > 0 ? 1 : 0) != 0);
        this.membershipOracle = membershipOracle;
        this.batchSize = batchSize;
    }

    @Nullable
    public DefaultQuery<I, D> findCounterExample(A hypothesis, Collection<? extends I> inputs) {
        if (inputs.isEmpty()) {
            LOGGER.warn("Passed empty set of inputs to equivalence oracle; no counterexample can be found!");
            return null;
        }
        Stream<Word<I>> testWordStream = this.generateTestWords(hypothesis, inputs);
        Stream<DefaultQuery<I, D>> queryStream = testWordStream.map(DefaultQuery::new);
        Stream<DefaultQuery<I, D>> answeredQueryStream = this.answerQueries(queryStream);
        Stream<DefaultQuery> ceStream = answeredQueryStream.filter(query -> {
            Object hypOutput = hypothesis.computeOutput((Iterable)query.getInput());
            return !Objects.equals(hypOutput, query.getOutput());
        });
        return ceStream.findFirst().orElse(null);
    }

    protected abstract Stream<Word<I>> generateTestWords(A var1, Collection<? extends I> var2);

    private Stream<DefaultQuery<I, D>> answerQueries(Stream<DefaultQuery<I, D>> stream) {
        if (this.isBatched()) {
            return Streams.stream(Streams.stream((Iterator)Iterators.partition(stream.iterator(), (int)this.batchSize)).peek(arg_0 -> this.membershipOracle.processQueries(arg_0)).flatMap(Collection::stream).iterator());
        }
        return stream.peek(arg_0 -> this.membershipOracle.processQuery(arg_0));
    }

    private boolean isBatched() {
        return this.batchSize > 1;
    }
}

