/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence.vpda;

import com.google.common.base.Preconditions;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.oracle.equivalence.AbstractTestWordEQOracle;
import java.util.Collection;
import java.util.Random;
import java.util.stream.Stream;
import net.automatalib.ts.acceptors.DeterministicAcceptorTS;
import net.automatalib.words.VPDAlphabet;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class RandomWellMatchedWordsEQOracle<I>
extends AbstractTestWordEQOracle<DeterministicAcceptorTS<?, I>, I, Boolean> {
    private final Random random;
    private final VPDAlphabet<I> alphabet;
    private final double callProb;
    private final int maxTests;
    private final int minLength;
    private final int maxLength;

    public RandomWellMatchedWordsEQOracle(Random random, MembershipOracle<I, Boolean> oracle, VPDAlphabet<I> alphabet, double callProb, int maxTests, int minLength, int maxLength) {
        this(random, oracle, alphabet, callProb, maxTests, minLength, maxLength, 1);
    }

    public RandomWellMatchedWordsEQOracle(Random random, MembershipOracle<I, Boolean> oracle, VPDAlphabet<I> alphabet, double callProb, int maxTests, int minLength, int maxLength, int batchSize) {
        super(oracle, batchSize);
        Preconditions.checkArgument((minLength <= maxLength ? 1 : 0) != 0, (Object)"minLength is smaller than maxLength");
        this.random = random;
        this.alphabet = alphabet;
        this.callProb = callProb;
        this.maxTests = maxTests;
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    protected Stream<Word<I>> generateTestWords(DeterministicAcceptorTS<?, I> hypothesis, Collection<? extends I> inputs) {
        int lengthRange = this.maxLength - this.minLength + 1;
        return Stream.generate(() -> this.generateWellMatched(this.minLength + this.random.nextInt(lengthRange))).limit(this.maxTests);
    }

    private Word<I> generateWellMatched(int len) {
        WordBuilder wb = new WordBuilder(len);
        this.generateWellMatched(wb, len);
        return wb.toWord();
    }

    private void generateWellMatched(WordBuilder<I> wb, int length) {
        if (length == 0) {
            return;
        }
        if (length == 1) {
            wb.append(this.alphabet.getInternalSymbol(this.random.nextInt(this.alphabet.getNumInternals())));
            return;
        }
        double act = this.random.nextDouble();
        if (act < this.callProb) {
            boolean dir = this.random.nextBoolean();
            if (dir) {
                int cpos = this.random.nextInt(length - 1);
                this.generateWellMatched(wb, cpos);
                wb.append(this.alphabet.getCallSymbol(this.random.nextInt(this.alphabet.getNumCalls())));
                int rpos = cpos + 1 + this.random.nextInt(length - cpos - 1);
                this.generateWellMatched(wb, rpos - cpos - 1);
                wb.append(this.alphabet.getReturnSymbol(this.random.nextInt(this.alphabet.getNumReturns())));
                this.generateWellMatched(wb, length - rpos - 1);
            } else {
                int rpos = 1 + this.random.nextInt(length - 1);
                int cpos = this.random.nextInt(rpos);
                this.generateWellMatched(wb, cpos);
                wb.append(this.alphabet.getCallSymbol(this.random.nextInt(this.alphabet.getNumCalls())));
                this.generateWellMatched(wb, rpos - cpos - 1);
                wb.append(this.alphabet.getReturnSymbol(this.random.nextInt(this.alphabet.getNumReturns())));
                this.generateWellMatched(wb, length - rpos - 1);
            }
        } else {
            int sep = 1 + this.random.nextInt(length - 1);
            this.generateWellMatched(wb, sep);
            this.generateWellMatched(wb, length - sep);
        }
    }
}

