/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence;

import com.google.common.collect.Streams;
import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.oracle.equivalence.AbstractTestWordEQOracle;
import java.util.Collection;
import java.util.Iterator;
import java.util.stream.Stream;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.concepts.Output;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.util.automata.conformance.WpMethodTestsIterator;
import net.automatalib.words.Word;

public class WpMethodEQOracle<A extends UniversalDeterministicAutomaton<?, I, ?, ?, ?> & Output<I, D>, I, D>
extends AbstractTestWordEQOracle<A, I, D> {
    private final int maxDepth;

    public WpMethodEQOracle(MembershipOracle<I, D> sulOracle, int maxDepth) {
        this(sulOracle, maxDepth, 1);
    }

    public WpMethodEQOracle(MembershipOracle<I, D> sulOracle, int maxDepth, int batchSize) {
        super(sulOracle, batchSize);
        this.maxDepth = maxDepth;
    }

    @Override
    protected Stream<Word<I>> generateTestWords(A hypothesis, Collection<? extends I> inputs) {
        return Streams.stream((Iterator)new WpMethodTestsIterator(hypothesis, inputs, this.maxDepth));
    }

    public static class MealyWpMethodEQOracle<I, O>
    extends WpMethodEQOracle<MealyMachine<?, I, ?, O>, I, Word<O>> {
        public MealyWpMethodEQOracle(MembershipOracle<I, Word<O>> sulOracle, int maxDepth) {
            super(sulOracle, maxDepth);
        }

        public MealyWpMethodEQOracle(MembershipOracle<I, Word<O>> sulOracle, int maxDepth, int batchSize) {
            super(sulOracle, maxDepth, batchSize);
        }
    }

    public static class DFAWpMethodEQOracle<I>
    extends WpMethodEQOracle<DFA<?, I>, I, Boolean>
    implements EquivalenceOracle.DFAEquivalenceOracle<I> {
        public DFAWpMethodEQOracle(MembershipOracle<I, Boolean> sulOracle, int maxDepth) {
            super(sulOracle, maxDepth);
        }

        public DFAWpMethodEQOracle(MembershipOracle<I, Boolean> sulOracle, int maxDepth, int batchSize) {
            super(sulOracle, maxDepth, batchSize);
        }
    }
}

