/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence;

import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.api.query.DefaultQuery;
import java.util.Collection;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.concepts.Output;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.util.automata.Automata;
import net.automatalib.words.Word;

public class SimulatorEQOracle<I, D>
implements EquivalenceOracle<UniversalDeterministicAutomaton<?, I, ?, ?, ?>, I, D> {
    private final UniversalDeterministicAutomaton<?, I, ?, ?, ?> reference;
    private final Output<I, D> output;

    public <R extends UniversalDeterministicAutomaton<?, I, ?, ?, ?> & Output<I, D>> SimulatorEQOracle(R reference) {
        this.reference = reference;
        this.output = reference;
    }

    public DefaultQuery<I, D> findCounterExample(UniversalDeterministicAutomaton<?, I, ?, ?, ?> hypothesis, Collection<? extends I> inputs) {
        Word sep = Automata.findSeparatingWord(this.reference, hypothesis, inputs);
        if (sep == null) {
            return null;
        }
        return new DefaultQuery(sep, this.output.computeOutput((Iterable)sep));
    }

    public static class MealySimulatorEQOracle<I, O>
    implements EquivalenceOracle.MealyEquivalenceOracle<I, O> {
        private final SimulatorEQOracle<I, Word<O>> delegate;

        public MealySimulatorEQOracle(MealyMachine<?, I, ?, O> mealy) {
            this.delegate = new SimulatorEQOracle(mealy);
        }

        public DefaultQuery<I, Word<O>> findCounterExample(MealyMachine<?, I, ?, O> hypothesis, Collection<? extends I> inputs) {
            return this.delegate.findCounterExample((UniversalDeterministicAutomaton<?, ? extends I, ?, ?, ?>)hypothesis, inputs);
        }
    }

    public static class DFASimulatorEQOracle<I>
    implements EquivalenceOracle.DFAEquivalenceOracle<I> {
        private final SimulatorEQOracle<I, Boolean> delegate;

        public DFASimulatorEQOracle(DFA<?, I> dfa) {
            this.delegate = new SimulatorEQOracle(dfa);
        }

        public DefaultQuery<I, Boolean> findCounterExample(DFA<?, I> hypothesis, Collection<? extends I> inputs) {
            return this.delegate.findCounterExample((UniversalDeterministicAutomaton<?, ? extends I, ?, ?, ?>)hypothesis, inputs);
        }
    }
}

