/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence;

import com.google.common.collect.Streams;
import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.oracle.equivalence.AbstractTestWordEQOracle;
import java.util.Collection;
import java.util.stream.Stream;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.concepts.Output;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.util.automata.conformance.IncrementalWMethodTestsIterator;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class IncrementalWMethodEQOracle<A extends UniversalDeterministicAutomaton<?, I, ?, ?, ?> & Output<I, D>, I, D>
extends AbstractTestWordEQOracle<A, I, D> {
    private final IncrementalWMethodTestsIterator<I> incrementalWMethodIt;
    private int maxDepth;

    public IncrementalWMethodEQOracle(MembershipOracle<I, D> oracle, Alphabet<I> alphabet) {
        this(oracle, alphabet, 1);
    }

    public IncrementalWMethodEQOracle(MembershipOracle<I, D> oracle, Alphabet<I> alphabet, int maxDepth) {
        this(oracle, alphabet, maxDepth, 1);
    }

    public IncrementalWMethodEQOracle(MembershipOracle<I, D> oracle, Alphabet<I> alphabet, int maxDepth, int batchSize) {
        super(oracle, batchSize);
        this.incrementalWMethodIt = new IncrementalWMethodTestsIterator(alphabet);
        this.incrementalWMethodIt.setMaxDepth(maxDepth);
        this.maxDepth = maxDepth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.incrementalWMethodIt.setMaxDepth(maxDepth);
        this.maxDepth = maxDepth;
    }

    @Override
    protected Stream<Word<I>> generateTestWords(A hypothesis, Collection<? extends I> inputs) {
        this.incrementalWMethodIt.update(hypothesis);
        return Streams.stream(this.incrementalWMethodIt);
    }

    public static class MealyIncrementalWMethodEQOracle<I, O>
    extends IncrementalWMethodEQOracle<MealyMachine<?, I, ?, O>, I, Word<O>>
    implements EquivalenceOracle.MealyEquivalenceOracle<I, O> {
        public MealyIncrementalWMethodEQOracle(MembershipOracle<I, Word<O>> oracle, Alphabet<I> alphabet) {
            super(oracle, alphabet);
        }

        public MealyIncrementalWMethodEQOracle(MembershipOracle<I, Word<O>> oracle, Alphabet<I> alphabet, int maxDepth) {
            super(oracle, alphabet, maxDepth);
        }

        public MealyIncrementalWMethodEQOracle(MembershipOracle<I, Word<O>> oracle, Alphabet<I> alphabet, int maxDepth, int batchSize) {
            super(oracle, alphabet, maxDepth, batchSize);
        }
    }

    public static class DFAIncrementalWMethodEQOracle<I>
    extends IncrementalWMethodEQOracle<DFA<?, I>, I, Boolean>
    implements EquivalenceOracle.DFAEquivalenceOracle<I> {
        public DFAIncrementalWMethodEQOracle(MembershipOracle<I, Boolean> oracle, Alphabet<I> alphabet) {
            super(oracle, alphabet);
        }

        public DFAIncrementalWMethodEQOracle(MembershipOracle<I, Boolean> oracle, Alphabet<I> alphabet, int maxDepth) {
            super(oracle, alphabet, maxDepth);
        }

        public DFAIncrementalWMethodEQOracle(MembershipOracle<I, Boolean> oracle, Alphabet<I> alphabet, int maxDepth, int batchSize) {
            super(oracle, alphabet, maxDepth, batchSize);
        }
    }
}

