/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence;

import com.google.common.collect.Streams;
import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.oracle.equivalence.AbstractTestWordEQOracle;
import java.util.Collection;
import java.util.stream.Stream;
import net.automatalib.automata.concepts.Output;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.commons.util.collections.CollectionsUtil;
import net.automatalib.words.Word;

public class CompleteExplorationEQOracle<I, D>
extends AbstractTestWordEQOracle<Output<I, D>, I, D> {
    private final int minDepth;
    private final int maxDepth;

    public CompleteExplorationEQOracle(MembershipOracle<I, D> sulOracle, int maxDepth) {
        this(sulOracle, 1, maxDepth);
    }

    public CompleteExplorationEQOracle(MembershipOracle<I, D> sulOracle, int minDepth, int maxDepth) {
        this(sulOracle, minDepth, maxDepth, 1);
    }

    public CompleteExplorationEQOracle(MembershipOracle<I, D> sulOracle, int minDepth, int maxDepth, int batchSize) {
        super(sulOracle, batchSize);
        this.minDepth = Math.min(minDepth, maxDepth);
        this.maxDepth = Math.max(minDepth, maxDepth);
    }

    @Override
    protected Stream<Word<I>> generateTestWords(Output<I, D> hypothesis, Collection<? extends I> inputs) {
        return Streams.stream((Iterable)CollectionsUtil.allTuples(inputs, (int)this.minDepth, (int)this.maxDepth)).map(Word::fromList);
    }

    public static class MealyCompleteExplorationEQOracle<I, O>
    extends AbstractTestWordEQOracle<MealyMachine<?, I, ?, O>, I, Word<O>>
    implements EquivalenceOracle.MealyEquivalenceOracle<I, O> {
        private final CompleteExplorationEQOracle<I, Word<O>> delegate;

        public MealyCompleteExplorationEQOracle(MembershipOracle<I, Word<O>> mqOracle, int maxDepth) {
            super(mqOracle);
            this.delegate = new CompleteExplorationEQOracle<I, Word<O>>(mqOracle, maxDepth);
        }

        public MealyCompleteExplorationEQOracle(MembershipOracle<I, Word<O>> mqOracle, int minDepth, int maxDepth) {
            super(mqOracle);
            this.delegate = new CompleteExplorationEQOracle<I, Word<O>>(mqOracle, minDepth, maxDepth);
        }

        public MealyCompleteExplorationEQOracle(MembershipOracle<I, Word<O>> mqOracle, int minDepth, int maxDepth, int batchSize) {
            super(mqOracle, batchSize);
            this.delegate = new CompleteExplorationEQOracle<I, Word<O>>(mqOracle, minDepth, maxDepth, batchSize);
        }

        @Override
        protected Stream<Word<I>> generateTestWords(MealyMachine<?, I, ?, O> hypothesis, Collection<? extends I> inputs) {
            return this.delegate.generateTestWords((Output<? extends I, Word<O>>)hypothesis, inputs);
        }
    }

    public static class DFACompleteExplorationEQOracle<I>
    extends AbstractTestWordEQOracle<DFA<?, I>, I, Boolean>
    implements EquivalenceOracle.DFAEquivalenceOracle<I> {
        private final CompleteExplorationEQOracle<I, Boolean> delegate;

        public DFACompleteExplorationEQOracle(MembershipOracle<I, Boolean> mqOracle, int maxDepth) {
            super(mqOracle);
            this.delegate = new CompleteExplorationEQOracle<I, Boolean>(mqOracle, maxDepth);
        }

        public DFACompleteExplorationEQOracle(MembershipOracle<I, Boolean> mqOracle, int minDepth, int maxDepth) {
            super(mqOracle);
            this.delegate = new CompleteExplorationEQOracle<I, Boolean>(mqOracle, minDepth, maxDepth);
        }

        public DFACompleteExplorationEQOracle(MembershipOracle<I, Boolean> mqOracle, int minDepth, int maxDepth, int batchSize) {
            super(mqOracle, batchSize);
            this.delegate = new CompleteExplorationEQOracle<I, Boolean>(mqOracle, minDepth, maxDepth, batchSize);
        }

        @Override
        protected Stream<Word<I>> generateTestWords(DFA<?, I> hypothesis, Collection<? extends I> inputs) {
            return this.delegate.generateTestWords((Output<? extends I, Boolean>)hypothesis, inputs);
        }
    }
}

