/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence;

import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.oracle.equivalence.AbstractTestWordEQOracle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.stream.Stream;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.concepts.Output;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.util.automata.Automata;
import net.automatalib.util.automata.cover.Covers;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class RandomWpMethodEQOracle<A extends UniversalDeterministicAutomaton<?, I, ?, ?, ?> & Output<I, D>, I, D>
extends AbstractTestWordEQOracle<A, I, D> {
    private final int minimalSize;
    private final int rndLength;
    private final int bound;
    private final Random rand;

    public RandomWpMethodEQOracle(MembershipOracle<I, D> sulOracle, int minimalSize, int rndLength) {
        this(sulOracle, minimalSize, rndLength, 0);
    }

    public RandomWpMethodEQOracle(MembershipOracle<I, D> sulOracle, int minimalSize, int rndLength, int bound) {
        this(sulOracle, minimalSize, rndLength, bound, 1);
    }

    public RandomWpMethodEQOracle(MembershipOracle<I, D> sulOracle, int minimalSize, int rndLength, int bound, int batchSize) {
        super(sulOracle, batchSize);
        this.minimalSize = minimalSize;
        this.rndLength = rndLength;
        this.bound = bound;
        this.rand = new Random();
    }

    public RandomWpMethodEQOracle(MembershipOracle<I, D> sulOracle, int minimalSize, int rndLength, int bound, Random random, int batchSize) {
        super(sulOracle, batchSize);
        this.minimalSize = minimalSize;
        this.rndLength = rndLength;
        this.bound = bound;
        this.rand = random;
    }

    @Override
    protected Stream<Word<I>> generateTestWords(A hypothesis, Collection<? extends I> inputs) {
        A aut = hypothesis;
        return this.doGenerateTestWords((UniversalDeterministicAutomaton)aut, inputs);
    }

    protected <S> Stream<Word<I>> doGenerateTestWords(UniversalDeterministicAutomaton<S, I, ?, ?, ?> hypothesis, Collection<? extends I> inputs) {
        ArrayList stateCover = new ArrayList(hypothesis.size());
        Covers.stateCover(hypothesis, inputs, stateCover);
        ArrayList<? extends I> arrayAlphabet = new ArrayList<I>(inputs);
        ArrayList globalSuffixes = new ArrayList();
        Automata.characterizingSet(hypothesis, inputs, globalSuffixes);
        MutableMapping localSuffixSets = hypothesis.createStaticStateMapping();
        for (Object state : hypothesis.getStates()) {
            ArrayList suffixSet = new ArrayList();
            Automata.stateCharacterizingSet(hypothesis, inputs, state, suffixSet);
            localSuffixSets.put(state, suffixSet);
        }
        Stream<Word<I>> result = Stream.generate(() -> this.generateSingleTestWord(hypothesis, stateCover, arrayAlphabet, globalSuffixes, localSuffixSets));
        return this.bound > 0 ? result.limit(this.bound) : result;
    }

    private <S> Word<I> generateSingleTestWord(UniversalDeterministicAutomaton<S, I, ?, ?, ?> hypothesis, ArrayList<Word<I>> stateCover, ArrayList<I> arrayAlphabet, ArrayList<Word<I>> globalSuffixes, MutableMapping<S, ArrayList<Word<I>>> localSuffixSets) {
        WordBuilder wb = new WordBuilder(this.minimalSize + this.rndLength + 1);
        wb.append(stateCover.get(this.rand.nextInt(stateCover.size())));
        int size = this.minimalSize;
        while (size > 0 || this.rand.nextDouble() > 1.0 / ((double)this.rndLength + 1.0)) {
            wb.append(arrayAlphabet.get(this.rand.nextInt(arrayAlphabet.size())));
            if (size <= 0) continue;
            --size;
        }
        if (this.rand.nextBoolean()) {
            if (!globalSuffixes.isEmpty()) {
                wb.append(globalSuffixes.get(this.rand.nextInt(globalSuffixes.size())));
            }
        } else {
            Object state2 = hypothesis.getState((Iterable)wb);
            ArrayList localSuffixes = (ArrayList)localSuffixSets.get(state2);
            if (!localSuffixes.isEmpty()) {
                wb.append((Word)localSuffixes.get(this.rand.nextInt(localSuffixes.size())));
            }
        }
        return wb.toWord();
    }

    public static class MealyRandomWpMethodEQOracle<I, O>
    extends RandomWpMethodEQOracle<MealyMachine<?, I, ?, O>, I, Word<O>>
    implements EquivalenceOracle.MealyEquivalenceOracle<I, O> {
        public MealyRandomWpMethodEQOracle(MembershipOracle<I, Word<O>> mqOracle, int minimalSize, int rndLength) {
            super(mqOracle, minimalSize, rndLength);
        }

        public MealyRandomWpMethodEQOracle(MembershipOracle<I, Word<O>> mqOracle, int minimalSize, int rndLength, int bound) {
            super(mqOracle, minimalSize, rndLength, bound);
        }

        public MealyRandomWpMethodEQOracle(MembershipOracle<I, Word<O>> mqOracle, int minimalSize, int rndLength, int bound, int batchSize) {
            super(mqOracle, minimalSize, rndLength, bound, batchSize);
        }

        public MealyRandomWpMethodEQOracle(MembershipOracle<I, Word<O>> mqOracle, int minimalSize, int rndLength, int bound, Random random, int batchSize) {
            super(mqOracle, minimalSize, rndLength, bound, random, batchSize);
        }
    }

    public static class DFARandomWpMethodEQOracle<I>
    extends RandomWpMethodEQOracle<DFA<?, I>, I, Boolean>
    implements EquivalenceOracle.DFAEquivalenceOracle<I> {
        public DFARandomWpMethodEQOracle(MembershipOracle<I, Boolean> mqOracle, int minimalSize, int rndLength) {
            super(mqOracle, minimalSize, rndLength);
        }

        public DFARandomWpMethodEQOracle(MembershipOracle<I, Boolean> mqOracle, int minimalSize, int rndLength, int bound) {
            super(mqOracle, minimalSize, rndLength, bound);
        }

        public DFARandomWpMethodEQOracle(MembershipOracle<I, Boolean> mqOracle, int minimalSize, int rndLength, int bound, int batchSize) {
            super(mqOracle, minimalSize, rndLength, bound, batchSize);
        }

        public DFARandomWpMethodEQOracle(MembershipOracle<I, Boolean> mqOracle, int minimalSize, int rndLength, int bound, Random random, int batchSize) {
            super(mqOracle, minimalSize, rndLength, bound, random, batchSize);
        }
    }
}

