/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence;

import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.oracle.equivalence.AbstractTestWordEQOracle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.automatalib.automata.concepts.Output;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class RandomWordsEQOracle<A extends Output<I, D>, I, D>
extends AbstractTestWordEQOracle<A, I, D> {
    private final Random random;
    private final int maxTests;
    private final int minLength;
    private final int maxLength;

    public RandomWordsEQOracle(MembershipOracle<I, D> mqOracle, int minLength, int maxLength, int maxTests) {
        this(mqOracle, minLength, maxLength, maxTests, new Random(), 1);
    }

    public RandomWordsEQOracle(MembershipOracle<I, D> mqOracle, int minLength, int maxLength, int maxTests, Random random) {
        this(mqOracle, minLength, maxLength, maxTests, random, 1);
    }

    public RandomWordsEQOracle(MembershipOracle<I, D> mqOracle, int minLength, int maxLength, int maxTests, Random random, int batchSize) {
        super(mqOracle, batchSize);
        this.maxTests = maxTests;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.random = random;
    }

    @Override
    protected Stream<Word<I>> generateTestWords(A hypothesis, Collection<? extends I> inputs) {
        ArrayList<I> symbolList = inputs instanceof List ? (ArrayList<I>)inputs : new ArrayList<I>(inputs);
        return Stream.generate(() -> this.generateTestWord(symbolList, symbolList.size())).limit(this.maxTests);
    }

    private Word<I> generateTestWord(List<? extends I> symbolList, int numSyms) {
        int length = this.minLength + this.random.nextInt(this.maxLength - this.minLength + 1);
        WordBuilder result = new WordBuilder(length);
        for (int j = 0; j < length; ++j) {
            int symidx = this.random.nextInt(numSyms);
            I sym = symbolList.get(symidx);
            result.append(sym);
        }
        return result.toWord();
    }

    public static class MealyRandomWordsEQOracle<I, O>
    extends RandomWordsEQOracle<MealyMachine<?, I, ?, O>, I, Word<O>>
    implements EquivalenceOracle.MealyEquivalenceOracle<I, O> {
        public MealyRandomWordsEQOracle(MembershipOracle<I, Word<O>> mqOracle, int minLength, int maxLength, int maxTests, Random random) {
            super(mqOracle, minLength, maxLength, maxTests, random);
        }

        public MealyRandomWordsEQOracle(MembershipOracle<I, Word<O>> mqOracle, int minLength, int maxLength, int maxTests, Random random, int batchSize) {
            super(mqOracle, minLength, maxLength, maxTests, random, batchSize);
        }
    }

    public static class DFARandomWordsEQOracle<I>
    extends RandomWordsEQOracle<DFA<?, I>, I, Boolean>
    implements EquivalenceOracle.DFAEquivalenceOracle<I> {
        public DFARandomWordsEQOracle(MembershipOracle<I, Boolean> mqOracle, int minLength, int maxLength, int maxTests, Random random) {
            super(mqOracle, minLength, maxLength, maxTests, random);
        }

        public DFARandomWordsEQOracle(MembershipOracle<I, Boolean> mqOracle, int minLength, int maxLength, int maxTests, Random random, int batchSize) {
            super(mqOracle, minLength, maxLength, maxTests, random, batchSize);
        }
    }
}

