/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.oracle.equivalence;

import de.learnlib.api.oracle.EquivalenceOracle;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.oracle.equivalence.AbstractTestWordEQOracle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.stream.Stream;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.concepts.Output;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.util.automata.Automata;
import net.automatalib.util.automata.cover.Covers;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;

public class RandomWMethodEQOracle<A extends UniversalDeterministicAutomaton<?, I, ?, ?, ?> & Output<I, D>, I, D>
extends AbstractTestWordEQOracle<A, I, D> {
    private final int minimalSize;
    private final int rndLength;
    private final int bound;
    private final Random rand;

    public RandomWMethodEQOracle(MembershipOracle<I, D> sulOracle, int minimalSize, int rndLength) {
        this(sulOracle, minimalSize, rndLength, 0);
    }

    public RandomWMethodEQOracle(MembershipOracle<I, D> sulOracle, int minimalSize, int rndLength, int bound) {
        this(sulOracle, minimalSize, rndLength, bound, new Random(), 1);
    }

    public RandomWMethodEQOracle(MembershipOracle<I, D> sulOracle, int minimalSize, int rndLength, int bound, int batchSize) {
        this(sulOracle, minimalSize, rndLength, bound, new Random(), batchSize);
    }

    public RandomWMethodEQOracle(MembershipOracle<I, D> sulOracle, int minimalSize, int rndLength, int bound, Random random, int batchSize) {
        super(sulOracle, batchSize);
        this.minimalSize = minimalSize;
        this.rndLength = rndLength;
        this.bound = bound;
        this.rand = random;
    }

    @Override
    protected Stream<Word<I>> generateTestWords(A hypothesis, Collection<? extends I> inputs) {
        A aut = hypothesis;
        return this.doGenerateTestWords((UniversalDeterministicAutomaton)aut, inputs);
    }

    private <S> Stream<Word<I>> doGenerateTestWords(UniversalDeterministicAutomaton<S, I, ?, ?, ?> hypothesis, Collection<? extends I> inputs) {
        ArrayList stateCover = new ArrayList(hypothesis.size());
        Covers.stateCover(hypothesis, inputs, stateCover);
        ArrayList<? extends I> arrayAlphabet = new ArrayList<I>(inputs);
        ArrayList globalSuffixes = new ArrayList();
        Automata.characterizingSet(hypothesis, inputs, globalSuffixes);
        Stream<Word<I>> result = Stream.generate(() -> this.generateSingleTestWord(stateCover, arrayAlphabet, globalSuffixes));
        return this.bound > 0 ? result.limit(this.bound) : result;
    }

    private Word<I> generateSingleTestWord(ArrayList<Word<I>> stateCover, ArrayList<I> arrayAlphabet, ArrayList<Word<I>> globalSuffixes) {
        WordBuilder wb = new WordBuilder(this.minimalSize + this.rndLength + 1);
        wb.append(stateCover.get(this.rand.nextInt(stateCover.size())));
        int size = this.minimalSize;
        while (size > 0 || this.rand.nextDouble() > 1.0 / ((double)this.rndLength + 1.0)) {
            wb.append(arrayAlphabet.get(this.rand.nextInt(arrayAlphabet.size())));
            if (size <= 0) continue;
            --size;
        }
        if (!globalSuffixes.isEmpty()) {
            wb.append(globalSuffixes.get(this.rand.nextInt(globalSuffixes.size())));
        }
        return wb.toWord();
    }

    public static class MealyRandomWMethodEQOracle<I, O>
    extends RandomWMethodEQOracle<MealyMachine<?, I, ?, O>, I, Word<O>>
    implements EquivalenceOracle.MealyEquivalenceOracle<I, O> {
        public MealyRandomWMethodEQOracle(MembershipOracle<I, Word<O>> mqOracle, int minimalSize, int rndLength) {
            super(mqOracle, minimalSize, rndLength);
        }

        public MealyRandomWMethodEQOracle(MembershipOracle<I, Word<O>> mqOracle, int minimalSize, int rndLength, int bound) {
            super(mqOracle, minimalSize, rndLength, bound);
        }

        public MealyRandomWMethodEQOracle(MembershipOracle<I, Word<O>> mqOracle, int minimalSize, int rndLength, int bound, int batchSize) {
            super(mqOracle, minimalSize, rndLength, bound, batchSize);
        }

        public MealyRandomWMethodEQOracle(MembershipOracle<I, Word<O>> mqOracle, int minimalSize, int rndLength, int bound, Random random, int batchSize) {
            super(mqOracle, minimalSize, rndLength, bound, random, batchSize);
        }
    }

    public static class DFARandomWMethodEQOracle<I>
    extends RandomWMethodEQOracle<DFA<?, I>, I, Boolean>
    implements EquivalenceOracle.DFAEquivalenceOracle<I> {
        public DFARandomWMethodEQOracle(MembershipOracle<I, Boolean> mqOracle, int minimalSize, int rndLength) {
            super(mqOracle, minimalSize, rndLength);
        }

        public DFARandomWMethodEQOracle(MembershipOracle<I, Boolean> mqOracle, int minimalSize, int rndLength, int bound) {
            super(mqOracle, minimalSize, rndLength, bound);
        }

        public DFARandomWMethodEQOracle(MembershipOracle<I, Boolean> mqOracle, int minimalSize, int rndLength, int bound, int batchSize) {
            super(mqOracle, minimalSize, rndLength, bound, batchSize);
        }

        public DFARandomWMethodEQOracle(MembershipOracle<I, Boolean> mqOracle, int minimalSize, int rndLength, int bound, Random random, int batchSize) {
            super(mqOracle, minimalSize, rndLength, bound, random, batchSize);
        }
    }
}

