/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.driver.util;

import de.learnlib.api.SUL;
import de.learnlib.api.exception.SULException;
import net.automatalib.automata.transout.MealyMachine;

public class MealySimulatorSUL<I, O>
implements SUL<I, O> {
    private final MealySimulatorSULImpl<?, I, ?, O> impl;

    public MealySimulatorSUL(MealyMachine<?, I, ?, O> mealy) {
        this(mealy, null);
    }

    public MealySimulatorSUL(MealyMachine<?, I, ?, O> mealy, O noTransOut) {
        this(new MealySimulatorSULImpl(mealy, noTransOut));
    }

    private MealySimulatorSUL(MealySimulatorSULImpl<?, I, ?, O> impl) {
        this.impl = impl;
    }

    public void pre() {
        this.impl.pre();
    }

    public void post() {
        this.impl.post();
    }

    public O step(I in) throws SULException {
        return this.impl.step(in);
    }

    public boolean canFork() {
        return this.impl.canFork();
    }

    public SUL<I, O> fork() {
        return new MealySimulatorSUL<I, O>(this.impl.fork());
    }

    private static final class MealySimulatorSULImpl<S, I, T, O>
    implements SUL<I, O> {
        private final MealyMachine<S, I, T, O> mealy;
        private final O noTransOut;
        private S curr;

        MealySimulatorSULImpl(MealyMachine<S, I, T, O> mealy, O noTransOut) {
            this.mealy = mealy;
            this.noTransOut = noTransOut;
        }

        public void pre() {
            this.curr = this.mealy.getInitialState();
        }

        public void post() {
            this.curr = null;
        }

        public O step(I in) throws SULException {
            Object out = this.noTransOut;
            if (this.curr != null) {
                Object trans = this.mealy.getTransition(this.curr, in);
                if (trans != null) {
                    out = this.mealy.getTransitionOutput(trans);
                    this.curr = this.mealy.getSuccessor(trans);
                } else {
                    this.curr = null;
                }
            }
            return out;
        }

        public boolean canFork() {
            return true;
        }

        public MealySimulatorSULImpl<S, I, T, O> fork() {
            return new MealySimulatorSULImpl<S, I, T, O>(this.mealy, this.noTransOut);
        }
    }
}

