/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.drivers.reflect;

import de.learnlib.drivers.api.ExecutableInput;
import de.learnlib.drivers.api.SULException;
import de.learnlib.drivers.reflect.AbstractMethodInput;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;

final class ConcreteMethodInput
implements ExecutableInput<Object> {
    private final AbstractMethodInput input;
    private final Map<String, Object> values;
    private final Object target;

    public ConcreteMethodInput(AbstractMethodInput input, Map<String, Object> values, Object target) {
        this.input = input;
        this.values = values;
        this.target = target;
    }

    private Object[] getParameterValues() {
        return this.input.getParameters(this.values);
    }

    public String toString() {
        return this.target + "." + this.input.getMethod().getName() + Arrays.toString(this.getParameterValues());
    }

    @Override
    public Object execute() throws SULException {
        Object out = null;
        try {
            Object ret = this.input.getMethod().invoke(this.target, this.getParameterValues());
            out = this.input.getMethod().getReturnType().equals(Void.TYPE) ? Void.TYPE : ret;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new SULException(e.getCause());
        }
        return out;
    }
}

