/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.drivers.reflect;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.KeyFor;

public class MethodInput {
    private final String name;
    private final Method method;
    private final Map<String, Integer> parameters;
    private final Object[] values;

    public MethodInput(String name, Method method, Map<String, Integer> parameters, Object[] values) {
        this.name = name;
        this.method = method;
        this.parameters = parameters;
        this.values = values;
    }

    public String toString() {
        return this.name() + Arrays.toString(this.parameters.keySet().toArray());
    }

    public String name() {
        return this.name;
    }

    public String getCall() {
        HashMap<String, Object> names = new HashMap<String, Object>();
        for (String p : this.getParameterNames()) {
            names.put(p, p);
        }
        return this.method.getName() + Arrays.toString(this.getParameters(names));
    }

    public Collection<@KeyFor(value={"parameters"}) String> getParameterNames() {
        return this.parameters.keySet();
    }

    public Object[] getParameters(Map<String, Object> fill) {
        Object[] ret = new Object[this.values.length];
        System.arraycopy(this.values, 0, ret, 0, this.values.length);
        for (Map.Entry<String, Object> e : fill.entrySet()) {
            Integer idx = this.parameters.get(e.getKey());
            ret[idx.intValue()] = e.getValue();
        }
        return ret;
    }

    public Class<?> getParameterType(@KeyFor(value={"parameters"}) String name) {
        int id = this.parameters.get(name);
        return this.method.getParameterTypes()[id];
    }

    public Method getMethod() {
        return this.method;
    }
}

