/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.drivers.reflect;

import de.learnlib.api.exception.SULException;
import de.learnlib.drivers.reflect.MethodInput;
import de.learnlib.mapper.api.ExecutableInput;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConcreteMethodInput
implements ExecutableInput<Object> {
    private final MethodInput input;
    private final Map<String, Object> values;
    private final Object target;

    public ConcreteMethodInput(MethodInput input, Map<String, Object> values, Object target) {
        this.input = input;
        this.values = values;
        this.target = target;
    }

    public String toString() {
        return this.target + "." + this.input.getMethod().getName() + Arrays.toString(this.getParameterValues());
    }

    private Object[] getParameterValues() {
        return this.input.getParameters(this.values);
    }

    public @Nullable Object execute() {
        Object out;
        try {
            Object ret = this.input.getMethod().invoke(this.target, this.getParameterValues());
            out = this.input.getMethod().getReturnType().equals(Void.TYPE) ? Void.TYPE : ret;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new SULException(e.getCause());
        }
        return out;
    }
}

