/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.discriminationtree.hypothesis;

import de.learnlib.algorithms.discriminationtree.hypothesis.HState;
import de.learnlib.datastructure.discriminationtree.model.AbstractWordBasedDTNode;
import java.io.Serializable;
import java.util.List;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HTransition<I, O, SP, TP>
implements Serializable {
    private final HState<I, O, SP, TP> source;
    private final I symbol;
    private TP property;
    private @Nullable HState<I, O, SP, TP> treeTgt;
    private @Nullable AbstractWordBasedDTNode<I, O, HState<I, O, SP, TP>> dt;

    public HTransition(HState<I, O, SP, TP> source, I symbol, AbstractWordBasedDTNode<I, O, HState<I, O, SP, TP>> dtTgt) {
        this.source = source;
        this.symbol = symbol;
        this.treeTgt = null;
        this.dt = dtTgt;
    }

    public HState<I, O, SP, TP> getSource() {
        return this.source;
    }

    public I getSymbol() {
        return this.symbol;
    }

    public TP getProperty() {
        return this.property;
    }

    public void setProperty(TP property) {
        this.property = property;
    }

    public HState<I, O, SP, TP> getTreeTarget() {
        assert (this.isTree());
        return this.treeTgt;
    }

    @EnsuresNonNullIf(expression={"treeTgt"}, result=true)
    public boolean isTree() {
        return this.treeTgt != null;
    }

    @EnsuresNonNullIf(expression={"dt"}, result=true)
    public boolean isNonTree() {
        return this.dt != null;
    }

    public AbstractWordBasedDTNode<I, O, HState<I, O, SP, TP>> getDT() {
        assert (this.isNonTree());
        return this.dt;
    }

    public void setDT(AbstractWordBasedDTNode<I, O, HState<I, O, SP, TP>> dtNode) {
        assert (!this.isTree());
        this.dt = dtNode;
    }

    public void makeTree(HState<I, O, SP, TP> treeTgt) {
        if (this.treeTgt != null) {
            throw new IllegalStateException("Cannot make transition [" + this.getAccessSequence() + "] a tree transition: already is");
        }
        this.treeTgt = treeTgt;
        this.dt = null;
    }

    public Word<I> getAccessSequence() {
        WordBuilder wb = new WordBuilder(this.source.getDepth() + 1);
        this.source.appendAccessSequence((List<I>)wb);
        wb.append(this.symbol);
        return wb.toWord();
    }

    public HState<I, O, SP, TP> nonTreeTarget() {
        assert (this.isNonTree());
        return (HState)this.dt.getData();
    }

    public HState<I, O, SP, TP> currentTarget() {
        if (this.treeTgt != null) {
            return this.treeTgt;
        }
        if (this.dt != null) {
            return (HState)this.dt.getData();
        }
        throw new IllegalStateException("Neither tree target not DT node provided");
    }
}

