/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.discriminationtree.hypothesis;

import de.learnlib.algorithms.discriminationtree.hypothesis.HTransition;
import de.learnlib.datastructure.discriminationtree.model.AbstractWordBasedDTNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.automatalib.commons.smartcollections.ResizingArrayStorage;
import net.automatalib.words.Word;
import net.automatalib.words.WordBuilder;
import org.checkerframework.checker.nullness.qual.Nullable;

public class HState<I, O, SP, TP>
implements Serializable {
    private final @Nullable HTransition<I, O, SP, TP> treeIncoming;
    private final int id;
    private final int depth;
    private final ResizingArrayStorage<HTransition<I, O, SP, TP>> transitions;
    private final List<HTransition<I, O, SP, TP>> nonTreeIncoming = new ArrayList<HTransition<I, O, SP, TP>>();
    private AbstractWordBasedDTNode<I, O, HState<I, O, SP, TP>> dtLeaf;
    private SP property;

    public HState(int alphabetSize) {
        this(alphabetSize, 0, null);
    }

    public HState(int initialAlphabetSize, int id, @Nullable HTransition<I, O, SP, TP> treeIncoming) {
        this.id = id;
        this.treeIncoming = treeIncoming;
        this.depth = treeIncoming == null ? 0 : treeIncoming.getSource().depth + 1;
        this.transitions = new ResizingArrayStorage(HTransition.class, initialAlphabetSize);
    }

    public AbstractWordBasedDTNode<I, O, HState<I, O, SP, TP>> getDTLeaf() {
        return this.dtLeaf;
    }

    public void setDTLeaf(AbstractWordBasedDTNode<I, O, HState<I, O, SP, TP>> dtLeaf) {
        this.dtLeaf = dtLeaf;
    }

    public @Nullable HTransition<I, O, SP, TP> getTreeIncoming() {
        return this.treeIncoming;
    }

    public void appendAccessSequence(List<? super I> symList) {
        if (this.treeIncoming == null) {
            return;
        }
        this.treeIncoming.getSource().appendAccessSequence(symList);
        symList.add(this.treeIncoming.getSymbol());
    }

    public Word<I> getAccessSequence() {
        if (this.treeIncoming == null) {
            return Word.epsilon();
        }
        WordBuilder wb = new WordBuilder(this.depth);
        this.appendAccessSequence((List<? super I>)wb);
        return wb.toWord();
    }

    public SP getProperty() {
        return this.property;
    }

    public void setProperty(SP property) {
        this.property = property;
    }

    public int getId() {
        return this.id;
    }

    public HTransition<I, O, SP, TP> getTransition(int transIdx) {
        return ((HTransition[])this.transitions.array)[transIdx];
    }

    public void setTransition(int transIdx, HTransition<I, O, SP, TP> transition) {
        ((HTransition[])this.transitions.array)[transIdx] = transition;
    }

    public Collection<HTransition<I, O, SP, TP>> getOutgoingTransitions() {
        return Collections.unmodifiableList(Arrays.asList(this.transitions.array));
    }

    public int getDepth() {
        return this.depth;
    }

    public void addNonTreeIncoming(HTransition<I, O, SP, TP> trans) {
        this.nonTreeIncoming.add(trans);
    }

    public void fetchNonTreeIncoming(Collection<? super HTransition<I, O, SP, TP>> target) {
        target.addAll(this.nonTreeIncoming);
        this.nonTreeIncoming.clear();
    }

    public boolean ensureInputCapacity(int capacity) {
        return this.transitions.ensureCapacity(capacity);
    }

    public String toString() {
        return "q" + this.id;
    }
}

