/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.discriminationtree.dfa;

import de.learnlib.algorithms.discriminationtree.AbstractDTLearner;
import de.learnlib.algorithms.discriminationtree.DTLearnerState;
import de.learnlib.algorithms.discriminationtree.dfa.HypothesisWrapperDFA;
import de.learnlib.algorithms.discriminationtree.hypothesis.HState;
import de.learnlib.algorithms.discriminationtree.hypothesis.HTransition;
import de.learnlib.api.algorithm.LearningAlgorithm;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.AbstractQuery;
import de.learnlib.api.query.Query;
import de.learnlib.counterexamples.LocalSuffixFinder;
import de.learnlib.counterexamples.LocalSuffixFinders;
import de.learnlib.datastructure.discriminationtree.BinaryDTree;
import de.learnlib.datastructure.discriminationtree.model.AbstractWordBasedDTNode;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class DTLearnerDFA<I>
extends AbstractDTLearner<DFA<?, I>, I, Boolean, Boolean, Void>
implements LearningAlgorithm.DFALearner<I> {
    private HypothesisWrapperDFA<I> hypWrapper;

    public DTLearnerDFA(Alphabet<I> alphabet, MembershipOracle<I, Boolean> oracle, LocalSuffixFinder<? super I, ? super Boolean> suffixFinder, boolean repeatedCounterexampleEvaluation, boolean epsilonRoot) {
        super(alphabet, oracle, suffixFinder, repeatedCounterexampleEvaluation, new BinaryDTree(oracle));
        this.hypWrapper = new HypothesisWrapperDFA(this.hypothesis);
        if (epsilonRoot) {
            ((AbstractWordBasedDTNode)this.dtree.getRoot()).split((Object)Word.epsilon(), (Object)false, (Object)true);
        }
    }

    public DFA<?, I> getHypothesisModel() {
        return this.hypWrapper;
    }

    @Override
    protected Query<I, Boolean> spQuery(final HState<I, Boolean, Boolean, Void> state) {
        return new AbstractQuery<I, Boolean>(state.getAccessSequence(), Word.epsilon()){

            public void answer(Boolean val) {
                state.setProperty(val);
            }
        };
    }

    @Override
    protected Query<I, Boolean> tpQuery(HTransition<I, Boolean, Boolean, Void> transition) {
        return null;
    }

    @Override
    public void resume(DTLearnerState<I, Boolean, Boolean, Void> state) {
        super.resume(state);
        this.hypWrapper = new HypothesisWrapperDFA(this.hypothesis);
    }

    public static class BuilderDefaults {
        public static boolean epsilonRoot() {
            return true;
        }

        public static <I, O> LocalSuffixFinder<? super I, ? super O> suffixFinder() {
            return LocalSuffixFinders.RIVEST_SCHAPIRE;
        }

        public static boolean repeatedCounterexampleEvaluation() {
            return true;
        }
    }
}

