/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.discriminationtree;

import de.learnlib.algorithms.discriminationtree.DTLearnerState;
import de.learnlib.algorithms.discriminationtree.hypothesis.DTLearnerHypothesis;
import de.learnlib.algorithms.discriminationtree.hypothesis.HState;
import de.learnlib.algorithms.discriminationtree.hypothesis.HTransition;
import de.learnlib.api.algorithm.LearningAlgorithm;
import de.learnlib.api.algorithm.feature.ResumableLearner;
import de.learnlib.api.algorithm.feature.SupportsGrowingAlphabet;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.api.query.Query;
import de.learnlib.counterexamples.LocalSuffixFinder;
import de.learnlib.counterexamples.LocalSuffixFinders;
import de.learnlib.datastructure.discriminationtree.model.AbstractDTNode;
import de.learnlib.datastructure.discriminationtree.model.AbstractWordBasedDTNode;
import de.learnlib.datastructure.discriminationtree.model.AbstractWordBasedDiscriminationTree;
import de.learnlib.util.MQUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.impl.Alphabets;

public abstract class AbstractDTLearner<M extends SuffixOutput<I, D>, I, D, SP, TP>
implements LearningAlgorithm<M, I, D>,
SupportsGrowingAlphabet<I>,
ResumableLearner<DTLearnerState<I, D, SP, TP>> {
    protected Alphabet<I> alphabet;
    private final MembershipOracle<I, D> oracle;
    private final LocalSuffixFinder<? super I, ? super D> suffixFinder;
    private final boolean repeatedCounterexampleEvaluation;
    private final List<HState<I, D, SP, TP>> newStates = new ArrayList<HState<I, D, SP, TP>>();
    private final List<HTransition<I, D, SP, TP>> newTransitions = new ArrayList<HTransition<I, D, SP, TP>>();
    private final Deque<HTransition<I, D, SP, TP>> openTransitions = new ArrayDeque<HTransition<I, D, SP, TP>>();
    protected AbstractWordBasedDiscriminationTree<I, D, HState<I, D, SP, TP>> dtree;
    protected DTLearnerHypothesis<I, D, SP, TP> hypothesis;

    protected AbstractDTLearner(Alphabet<I> alphabet, MembershipOracle<I, D> oracle, LocalSuffixFinder<? super I, ? super D> suffixFinder, boolean repeatedCounterexampleEvaluation, AbstractWordBasedDiscriminationTree<I, D, HState<I, D, SP, TP>> dtree) {
        this.alphabet = alphabet;
        this.oracle = oracle;
        this.suffixFinder = suffixFinder;
        this.hypothesis = new DTLearnerHypothesis(alphabet);
        this.dtree = dtree;
        this.repeatedCounterexampleEvaluation = repeatedCounterexampleEvaluation;
    }

    public void startLearning() {
        Object init = this.hypothesis.getInitialState();
        AbstractWordBasedDTNode initDt = (AbstractWordBasedDTNode)this.dtree.sift(((HState)init).getAccessSequence());
        if (initDt.getData() != null) {
            throw new IllegalStateException("Decision tree already contains data");
        }
        initDt.setData(init);
        ((HState)init).setDTLeaf(initDt);
        this.initializeState((HState<I, D, SP, TP>)init);
        this.updateHypothesis();
    }

    public boolean refineHypothesis(DefaultQuery<I, D> ceQuery) {
        if (!this.refineHypothesisSingle(ceQuery)) {
            return false;
        }
        if (this.repeatedCounterexampleEvaluation) {
            while (this.refineHypothesisSingle(ceQuery)) {
            }
        }
        return true;
    }

    protected boolean refineHypothesisSingle(DefaultQuery<I, D> ceQuery) {
        if (!MQUtil.isCounterexample(ceQuery, (SuffixOutput)((SuffixOutput)this.getHypothesisModel()))) {
            return false;
        }
        int suffixIdx = this.suffixFinder.findSuffixIndex(ceQuery, this.hypothesis, (SuffixOutput)this.getHypothesisModel(), this.oracle);
        if (suffixIdx == -1) {
            throw new AssertionError((Object)"Suffix finder does not work correctly, found no suffix for valid counterexample");
        }
        Word input = ceQuery.getInput();
        Word oldStateAs = input.prefix(suffixIdx);
        HState oldState = (HState)this.hypothesis.getState((Iterable)oldStateAs);
        AbstractWordBasedDTNode oldDt = oldState.getDTLeaf();
        Word newPredAs = input.prefix(suffixIdx - 1);
        HState newPred = (HState)this.hypothesis.getState((Iterable)newPredAs);
        Object transSym = input.getSymbol(suffixIdx - 1);
        int transIdx = this.alphabet.getSymbolIndex(transSym);
        HTransition trans = newPred.getTransition(transIdx);
        HState newState = this.createState(trans);
        Word suffix = input.subWord(suffixIdx);
        Object oldOut = this.oracle.answerQuery(oldState.getAccessSequence(), suffix);
        Object newOut = this.oracle.answerQuery(newState.getAccessSequence(), suffix);
        AbstractDTNode.SplitResult sr = oldDt.split((Object)suffix, oldOut, newOut, newState);
        oldState.fetchNonTreeIncoming(this.openTransitions);
        oldState.setDTLeaf((AbstractWordBasedDTNode)sr.nodeOld);
        newState.setDTLeaf((AbstractWordBasedDTNode)sr.nodeNew);
        this.updateHypothesis();
        return true;
    }

    protected void initializeState(HState<I, D, SP, TP> newState) {
        this.newStates.add(newState);
        int size = this.alphabet.size();
        for (int i = 0; i < size; ++i) {
            Object sym = this.alphabet.getSymbol(i);
            HTransition<Object, D, SP, TP> newTrans = new HTransition<Object, D, SP, TP>(newState, sym, (AbstractWordBasedDTNode)this.dtree.getRoot());
            newState.setTransition(i, newTrans);
            this.newTransitions.add(newTrans);
            this.openTransitions.offer(newTrans);
        }
    }

    protected void updateHypothesis() {
        HTransition<I, D, SP, TP> current;
        while ((current = this.openTransitions.poll()) != null) {
            this.updateTransition(current);
        }
        ArrayList<Query<I, D>> queries = new ArrayList<Query<I, D>>();
        for (HState<I, D, SP, TP> hState : this.newStates) {
            Query<I, D> spQuery = this.spQuery(hState);
            if (spQuery == null) continue;
            queries.add(spQuery);
        }
        this.newStates.clear();
        for (HTransition hTransition : this.newTransitions) {
            Query<I, D> tpQuery = this.tpQuery(hTransition);
            if (tpQuery == null) continue;
            queries.add(tpQuery);
        }
        this.newTransitions.clear();
        this.oracle.processQueries(queries);
    }

    protected void updateTransition(HTransition<I, D, SP, TP> trans) {
        if (trans.isTree()) {
            return;
        }
        AbstractWordBasedDTNode currDt = trans.getDT();
        currDt = this.dtree.sift(currDt, trans.getAccessSequence());
        trans.setDT(currDt);
        HState<I, D, SP, TP> state = (HState<I, D, SP, TP>)currDt.getData();
        if (state == null) {
            state = this.createState(trans);
            currDt.setData(state);
            state.setDTLeaf(currDt);
        } else {
            state.addNonTreeIncoming(trans);
        }
    }

    protected abstract Query<I, D> spQuery(HState<I, D, SP, TP> var1);

    protected abstract Query<I, D> tpQuery(HTransition<I, D, SP, TP> var1);

    protected HState<I, D, SP, TP> createState(HTransition<I, D, SP, TP> trans) {
        HState<I, D, SP, TP> newState = this.hypothesis.createState(trans);
        this.initializeState(newState);
        return newState;
    }

    public AbstractWordBasedDiscriminationTree<I, D, HState<I, D, SP, TP>> getDiscriminationTree() {
        return this.dtree;
    }

    public DTLearnerHypothesis<I, D, SP, TP> getHypothesisDS() {
        return this.hypothesis;
    }

    public void addAlphabetSymbol(I symbol) {
        if (this.alphabet.containsSymbol(symbol)) {
            return;
        }
        int newSymbolIdx = this.alphabet.size();
        this.hypothesis.addAlphabetSymbol(symbol);
        if (!this.alphabet.containsSymbol(symbol)) {
            this.alphabet = Alphabets.withNewSymbol(this.alphabet, symbol);
        }
        for (HState<I, D, SP, TP> s : this.hypothesis.getStates()) {
            HTransition<I, D, SP, TP> newTrans = new HTransition<I, D, SP, TP>(s, symbol, (AbstractWordBasedDTNode)this.dtree.getRoot());
            s.setTransition(newSymbolIdx, newTrans);
            this.newTransitions.add(newTrans);
            this.openTransitions.add(newTrans);
        }
        this.updateHypothesis();
    }

    public DTLearnerState<I, D, SP, TP> suspend() {
        return new DTLearnerState<I, D, SP, TP>(this.dtree, this.hypothesis);
    }

    public void resume(DTLearnerState<I, D, SP, TP> state) {
        this.hypothesis = state.getHypothesis();
        this.dtree = state.getDtree();
        this.dtree.setOracle(this.oracle);
    }

    public static class BuilderDefaults {
        public static <I, O> LocalSuffixFinder<? super I, ? super O> suffixFinder() {
            return LocalSuffixFinders.RIVEST_SCHAPIRE;
        }

        public static boolean repeatedCounterexampleEvaluation() {
            return true;
        }
    }
}

