/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.discriminationtree;

import com.google.common.collect.Iterables;
import de.learnlib.api.MembershipOracle;
import de.learnlib.discriminationtree.DTNode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.IndefiniteGraph;
import net.automatalib.graphs.dot.DefaultDOTHelper;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.util.graphs.traversal.GraphTraversal;
import net.automatalib.words.Word;

public class DiscriminationTree<I, O, D> {
    private final MembershipOracle<I, O> oracle;
    private final DTNode<I, O, D> root;

    public DiscriminationTree(DTNode<I, O, D> root, MembershipOracle<I, O> oracle) {
        this.root = root;
        this.oracle = oracle;
    }

    public DTNode<I, O, D> sift(Word<I> prefix) {
        return this.sift(this.root, prefix);
    }

    public DTNode<I, O, D> sift(DTNode<I, O, D> start, Word<I> prefix) {
        DTNode<I, Object, D> curr = start;
        while (!curr.isLeaf()) {
            Object out = this.oracle.answerQuery(prefix, curr.getDiscriminator());
            curr = curr.child(out);
        }
        return curr;
    }

    public DTNode<I, O, D> getRoot() {
        return this.root;
    }

    public DTNode<I, O, D> leastCommonAncestor(DTNode<I, O, D> node1, DTNode<I, O, D> node2) {
        DTNode<I, O, D> curr2;
        DTNode<I, O, D> curr1;
        int d2 = node2.depth;
        int d1 = node1.depth;
        int ddiff = d2 - d1;
        if (ddiff >= 0) {
            curr1 = node1;
            curr2 = node2;
        } else {
            curr1 = node2;
            curr2 = node1;
            ddiff *= -1;
        }
        while (ddiff > 0) {
            curr2 = curr2.parent;
            --ddiff;
        }
        if (curr1 == curr2) {
            return curr1;
        }
        while (curr1 != curr2) {
            curr1 = curr1.parent;
            curr2 = curr2.parent;
        }
        return curr1;
    }

    public LCAInfo<I, O, D> lcaInfo(DTNode<I, O, D> node1, DTNode<I, O, D> node2) {
        DTNode<I, O, D> curr2;
        DTNode<I, O, D> curr1;
        int d1 = node1.depth;
        int d2 = node2.depth;
        int ddiff = d2 - d1;
        boolean swap = false;
        if (ddiff >= 0) {
            curr1 = node1;
            curr2 = node2;
        } else {
            curr1 = node2;
            curr2 = node1;
            ddiff *= -1;
            swap = true;
        }
        Object out1 = null;
        Object out2 = null;
        while (ddiff > 0) {
            out2 = curr2.parentOutcome;
            curr2 = curr2.parent;
            --ddiff;
        }
        if (curr1 == curr2) {
            return new LCAInfo(curr1, out1, out2, swap);
        }
        while (curr1 != curr2) {
            out1 = curr1.parentOutcome;
            curr1 = curr1.parent;
            out2 = curr2.parentOutcome;
            curr2 = curr2.parent;
        }
        return new LCAInfo(curr1, out1, out2, swap);
    }

    public GraphView graphView() {
        return new GraphView();
    }

    public class GraphView
    implements Graph<DTNode<I, O, D>, Map.Entry<O, DTNode<I, O, D>>> {
        public Collection<DTNode<I, O, D>> getNodes() {
            ArrayList nodes = new ArrayList();
            Iterables.addAll(nodes, (Iterable)GraphTraversal.breadthFirstOrder((IndefiniteGraph)this, Collections.singleton(DiscriminationTree.this.root)));
            return nodes;
        }

        public Collection<Map.Entry<O, DTNode<I, O, D>>> getOutgoingEdges(DTNode<I, O, D> node) {
            if (node.isLeaf()) {
                return Collections.emptySet();
            }
            return node.getChildEntries();
        }

        public DTNode<I, O, D> getTarget(Map.Entry<O, DTNode<I, O, D>> edge) {
            return edge.getValue();
        }

        public GraphDOTHelper<DTNode<I, O, D>, Map.Entry<O, DTNode<I, O, D>>> getGraphDOTHelper() {
            return new DefaultDOTHelper<DTNode<I, O, D>, Map.Entry<O, DTNode<I, O, D>>>(){

                public boolean getNodeProperties(DTNode<I, O, D> node, Map<String, String> properties) {
                    if (!super.getNodeProperties(node, properties)) {
                        return false;
                    }
                    if (node.isLeaf()) {
                        properties.put("shape", "box");
                        properties.put("label", String.valueOf(node.getData()));
                    } else {
                        Word d = node.getDiscriminator();
                        properties.put("shape", "oval");
                        properties.put("label", d.toString());
                    }
                    return true;
                }

                public boolean getEdgeProperties(DTNode<I, O, D> src, Map.Entry<O, DTNode<I, O, D>> edge, DTNode<I, O, D> tgt, Map<String, String> properties) {
                    if (!super.getEdgeProperties(src, edge, tgt, properties)) {
                        return false;
                    }
                    properties.put("label", String.valueOf(edge.getKey()));
                    return true;
                }
            };
        }
    }

    public static class LCAInfo<I, O, D> {
        public final DTNode<I, O, D> leastCommonAncestor;
        public final O subtree1Label;
        public final O subtree2Label;

        public LCAInfo(DTNode<I, O, D> leastCommonAncestor, O subtree1Label, O subtree2Label) {
            this(leastCommonAncestor, subtree1Label, subtree2Label, false);
        }

        private LCAInfo(DTNode<I, O, D> leastCommonAncestor, O subtree1Label, O subtree2Label, boolean swap) {
            this.leastCommonAncestor = leastCommonAncestor;
            if (swap) {
                this.subtree1Label = subtree2Label;
                this.subtree2Label = subtree1Label;
            } else {
                this.subtree1Label = subtree1Label;
                this.subtree2Label = subtree2Label;
            }
        }
    }
}

