/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.discriminationtree;

import java.util.Collection;
import java.util.Map;
import net.automatalib.words.Word;

public abstract class DTNode<I, O, D> {
    protected final DTNode<I, O, D> parent;
    protected final O parentOutcome;
    protected final int depth;
    protected Map<O, DTNode<I, O, D>> children = null;
    protected Word<I> discriminator;
    protected D data;

    public DTNode(D data) {
        this(null, null, data);
    }

    protected DTNode(DTNode<I, O, D> parent, O parentOutcome, D data) {
        this.parent = parent;
        this.parentOutcome = parentOutcome;
        this.depth = parent != null ? parent.depth + 1 : 0;
        this.data = data;
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public DTNode<I, O, D> getParent() {
        return this.parent;
    }

    public O getParentOutcome() {
        return this.parentOutcome;
    }

    public Word<I> getDiscriminator() {
        return this.discriminator;
    }

    public DTNode<I, O, D> getChild(O out) {
        return this.children.get(out);
    }

    protected DTNode<I, O, D> addChild(O outcome, D data) {
        DTNode<I, O, D> child = this.createChild(outcome, data);
        this.children.put(outcome, child);
        return child;
    }

    public SplitResult<I, O, D> split(Word<I> discriminator, O oldOut, O newOut, D newData) {
        this.children = this.createChildMap();
        DTNode<I, O, D> nodeOld = this.addChild(oldOut, this.data);
        this.data = null;
        DTNode<I, O, D> nodeNew = this.addChild(newOut, newData);
        this.discriminator = discriminator;
        return new SplitResult<I, O, D>(nodeOld, nodeNew);
    }

    public DTNode<I, O, D> child(O out) {
        return this.child(out, null);
    }

    public DTNode<I, O, D> child(O out, D defaultData) {
        assert (!this.isLeaf());
        DTNode<I, O, D> result = this.getChild(out);
        if (result == null) {
            result = this.addChild(out, defaultData);
        }
        return result;
    }

    public boolean isLeaf() {
        return this.children == null;
    }

    public Collection<Map.Entry<O, DTNode<I, O, D>>> getChildEntries() {
        return this.children.entrySet();
    }

    public D getData() {
        assert (this.isLeaf());
        return this.data;
    }

    public void setData(D data) {
        assert (this.isLeaf());
        this.data = data;
    }

    protected abstract Map<O, DTNode<I, O, D>> createChildMap();

    protected abstract DTNode<I, O, D> createChild(O var1, D var2);

    public static class SplitResult<I, O, D> {
        public final DTNode<I, O, D> nodeOld;
        public final DTNode<I, O, D> nodeNew;

        public SplitResult(DTNode<I, O, D> nodeOld, DTNode<I, O, D> nodeNew) {
            this.nodeOld = nodeOld;
            this.nodeNew = nodeNew;
        }
    }
}

