/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.discriminationtree;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BooleanMap<V>
extends AbstractMap<Boolean, V> {
    private V falseValue;
    private V trueValue;

    public BooleanMap() {
    }

    public BooleanMap(V falseValue, V trueValue) {
        this.falseValue = falseValue;
        this.trueValue = trueValue;
    }

    public V get(boolean key) {
        if (key) {
            return this.trueValue;
        }
        return this.falseValue;
    }

    @Override
    public V put(boolean key, V value) {
        V old;
        if (key) {
            old = this.trueValue;
            this.trueValue = value;
        } else {
            old = this.falseValue;
            this.falseValue = value;
        }
        return old;
    }

    @Override
    public int size() {
        return 2;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        return Objects.equals(this.falseValue, value) || Objects.equals(this.trueValue, value);
    }

    @Override
    public boolean containsKey(Object key) {
        return key != null && key.getClass() == Boolean.class;
    }

    @Override
    public V get(Object key) {
        if (key == null || key.getClass() != Boolean.class) {
            return null;
        }
        boolean bval = (Boolean)key;
        return this.get(bval);
    }

    @Override
    public V put(Boolean key, V value) {
        if (key == null) {
            throw new IllegalArgumentException("BooleanMap disallows null keys");
        }
        boolean bval = key;
        return this.put(bval, value);
    }

    @Override
    public V remove(Object key) {
        if (key == null || key.getClass() != Boolean.class) {
            return null;
        }
        throw new UnsupportedOperationException("BooleanMap disallows removal");
    }

    @Override
    public void putAll(Map<? extends Boolean, ? extends V> m) {
        if (m.containsKey(null)) {
            throw new IllegalArgumentException("BooleanMap disallows null keys");
        }
        if (m.containsKey(false)) {
            this.falseValue = m.get(false);
        }
        if (m.containsKey(true)) {
            this.trueValue = m.get(true);
        }
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("BooleanMap disallows removal");
    }

    @Override
    public Set<Boolean> keySet() {
        return BooleanSet.INSTANCE;
    }

    @Override
    public Collection<V> values() {
        return Arrays.asList(this.falseValue, this.trueValue);
    }

    @Override
    public Set<Map.Entry<Boolean, V>> entrySet() {
        HashSet<Map.Entry<Boolean, V>> entries = new HashSet<Map.Entry<Boolean, V>>(2);
        entries.add(new Entry(false));
        entries.add(new Entry(true));
        return entries;
    }

    private class Entry
    implements Map.Entry<Boolean, V> {
        private final boolean key;

        public Entry(boolean key) {
            this.key = key;
        }

        @Override
        public Boolean getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return BooleanMap.this.get(this.key);
        }

        @Override
        public V setValue(V value) {
            return BooleanMap.this.put(this.key, value);
        }

        @Override
        public int hashCode() {
            return this.key ? 1 : 0;
        }
    }

    private static class BooleanSet
    extends AbstractSet<Boolean> {
        private static final List<Boolean> VALUES = Arrays.asList(false, true);
        private static final BooleanSet INSTANCE = new BooleanSet();

        private BooleanSet() {
        }

        @Override
        public Iterator<Boolean> iterator() {
            return VALUES.iterator();
        }

        @Override
        public int size() {
            return 2;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean contains(Object o) {
            return o.getClass() == Boolean.class;
        }
    }
}

