/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.discriminationtree.hypothesis;

import de.learnlib.algorithms.discriminationtree.hypothesis.HState;
import de.learnlib.algorithms.discriminationtree.hypothesis.HTransition;
import de.learnlib.api.AccessSequenceTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.automata.concepts.StateIDs;
import net.automatalib.graphs.Graph;
import net.automatalib.graphs.concepts.NodeIDs;
import net.automatalib.graphs.dot.DefaultDOTHelper;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class DTLearnerHypothesis<I, O, SP, TP>
implements UniversalDeterministicAutomaton<HState<I, O, SP, TP>, I, HTransition<I, O, SP, TP>, SP, TP>,
AccessSequenceTransformer<I>,
StateIDs<HState<I, O, SP, TP>> {
    private final Alphabet<I> alphabet;
    private final HState<I, O, SP, TP> root;
    private final List<HState<I, O, SP, TP>> nodes = new ArrayList<HState<I, O, SP, TP>>();

    public DTLearnerHypothesis(Alphabet<I> alphabet) {
        this.alphabet = alphabet;
        this.root = new HState(alphabet.size());
        this.nodes.add(this.root);
    }

    public HState<I, O, SP, TP> createState(HTransition<I, O, SP, TP> treeIncoming) {
        HState<I, O, SP, TP> state = new HState<I, O, SP, TP>(this.alphabet.size(), this.nodes.size(), treeIncoming);
        this.nodes.add(state);
        treeIncoming.makeTree(state);
        return state;
    }

    public HTransition<I, O, SP, TP> getTransition(HState<I, O, SP, TP> state, I symbol) {
        int symIdx = this.alphabet.getSymbolIndex(symbol);
        return state.getTransition(symIdx);
    }

    public Collection<HState<I, O, SP, TP>> getStates() {
        return Collections.unmodifiableCollection(this.nodes);
    }

    public StateIDs<HState<I, O, SP, TP>> stateIDs() {
        return this;
    }

    public HState<I, O, SP, TP> getInitialState() {
        return this.root;
    }

    public SP getStateProperty(HState<I, O, SP, TP> state) {
        return state.getProperty();
    }

    public HState<I, O, SP, TP> getState(int id) {
        return this.nodes.get(id);
    }

    public int getStateId(HState<I, O, SP, TP> state) {
        return state.getId();
    }

    public boolean isAccessSequence(Word<I> word) {
        HState<I, O, SP, TP> curr = this.root;
        for (Object sym : word) {
            int symIdx = this.alphabet.getSymbolIndex(sym);
            HTransition<I, O, SP, TP> trans = curr.getTransition(symIdx);
            if (!trans.isTree()) {
                return false;
            }
            curr = trans.getTreeTarget();
        }
        return true;
    }

    public Word<I> transformAccessSequence(Word<I> word) {
        HState state = (HState)this.getState((Iterable)word);
        return state.getAccessSequence();
    }

    public HState<I, O, SP, TP> getSuccessor(HTransition<I, O, SP, TP> trans) {
        return trans.currentTarget();
    }

    public TP getTransitionProperty(HTransition<I, O, SP, TP> trans) {
        return trans.getProperty();
    }

    public GraphView graphView() {
        return new GraphView();
    }

    public class GraphView
    implements Graph<HState<I, O, SP, TP>, HTransition<I, O, SP, TP>>,
    NodeIDs<HState<I, O, SP, TP>> {
        public Collection<HState<I, O, SP, TP>> getNodes() {
            return Collections.unmodifiableCollection(DTLearnerHypothesis.this.nodes);
        }

        public Collection<HTransition<I, O, SP, TP>> getOutgoingEdges(HState<I, O, SP, TP> node) {
            return node.getOutgoingTransitions();
        }

        public HState<I, O, SP, TP> getTarget(HTransition<I, O, SP, TP> edge) {
            return edge.currentTarget();
        }

        public NodeIDs<HState<I, O, SP, TP>> nodeIDs() {
            return this;
        }

        public HState<I, O, SP, TP> getNode(int id) {
            return (HState)DTLearnerHypothesis.this.nodes.get(id);
        }

        public int getNodeId(HState<I, O, SP, TP> node) {
            return node.getId();
        }

        public GraphDOTHelper<HState<I, O, SP, TP>, HTransition<I, O, SP, TP>> getGraphDOTHelper() {
            return new DefaultDOTHelper<HState<I, O, SP, TP>, HTransition<I, O, SP, TP>>(){

                protected Collection<? extends HState<I, O, SP, TP>> initialNodes() {
                    return Collections.singleton(DTLearnerHypothesis.this.root);
                }

                public boolean getNodeProperties(HState<I, O, SP, TP> node, Map<String, String> properties) {
                    if (!super.getNodeProperties(node, properties)) {
                        return false;
                    }
                    properties.put("label", node.toString());
                    return true;
                }

                public boolean getEdgeProperties(HState<I, O, SP, TP> src, HTransition<I, O, SP, TP> edge, HState<I, O, SP, TP> tgt, Map<String, String> properties) {
                    if (!super.getEdgeProperties(src, edge, tgt, properties)) {
                        return false;
                    }
                    properties.put("label", String.valueOf(edge.getSymbol()));
                    if (edge.isTree()) {
                        properties.put("style", "bold");
                    }
                    return true;
                }
            };
        }
    }
}

