/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.discriminationtree.dfa;

import de.learnlib.algorithms.discriminationtree.AbstractDTLearner;
import de.learnlib.algorithms.discriminationtree.dfa.HypothesisWrapperDFA;
import de.learnlib.algorithms.discriminationtree.hypothesis.HState;
import de.learnlib.algorithms.discriminationtree.hypothesis.HTransition;
import de.learnlib.api.LearningAlgorithm;
import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.counterexamples.LocalSuffixFinder;
import de.learnlib.counterexamples.LocalSuffixFinders;
import de.learnlib.discriminationtree.BinaryDTree;
import de.learnlib.oracles.AbstractQuery;
import java.util.Map;
import net.automatalib.automata.fsa.DFA;
import net.automatalib.graphs.dot.EmptyDOTHelper;
import net.automatalib.graphs.dot.GraphDOTHelper;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class DTLearnerDFA<I>
extends AbstractDTLearner<DFA<?, I>, I, Boolean, Boolean, Void>
implements LearningAlgorithm.DFALearner<I> {
    private final HypothesisWrapperDFA<I> hypWrapper;

    public DTLearnerDFA(Alphabet<I> alphabet, MembershipOracle<I, Boolean> oracle, LocalSuffixFinder<? super I, ? super Boolean> suffixFinder, boolean repeatedCounterexampleEvaluation, boolean epsilonRoot) {
        super(alphabet, oracle, suffixFinder, repeatedCounterexampleEvaluation, new BinaryDTree(oracle));
        this.hypWrapper = new HypothesisWrapperDFA(this.hypothesis);
        if (epsilonRoot) {
            this.dtree.getRoot().split(Word.epsilon(), false, true, null);
        }
    }

    public DFA<?, I> getHypothesisModel() {
        return this.hypWrapper;
    }

    @Override
    public GraphDOTHelper<HState<I, Boolean, Boolean, Void>, HTransition<I, Boolean, Boolean, Void>> getHypothesisDOTHelper() {
        return new EmptyDOTHelper<HState<I, Boolean, Boolean, Void>, HTransition<I, Boolean, Boolean, Void>>(){

            public boolean getNodeProperties(HState<I, Boolean, Boolean, Void> node, Map<String, String> properties) {
                if (node.getProperty().booleanValue()) {
                    properties.put("shape", "doublecircle");
                }
                return true;
            }
        };
    }

    @Override
    protected Query<I, Boolean> spQuery(final HState<I, Boolean, Boolean, Void> state) {
        return new AbstractQuery<I, Boolean>(state.getAccessSequence(), Word.epsilon()){

            public void answer(Boolean val) {
                state.setProperty(val);
            }
        };
    }

    @Override
    protected Query<I, Boolean> tpQuery(HTransition<I, Boolean, Boolean, Void> transition) {
        return null;
    }

    public static class BuilderDefaults {
        public static boolean epsilonRoot() {
            return true;
        }

        public static <I, O> LocalSuffixFinder<? super I, ? super O> suffixFinder() {
            return LocalSuffixFinders.RIVEST_SCHAPIRE;
        }

        public static boolean repeatedCounterexampleEvaluation() {
            return true;
        }
    }
}

