/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.discriminationtree;

import de.learnlib.algorithms.discriminationtree.hypothesis.DTLearnerHypothesis;
import de.learnlib.algorithms.discriminationtree.hypothesis.HState;
import de.learnlib.algorithms.discriminationtree.hypothesis.HTransition;
import de.learnlib.api.LearningAlgorithm;
import de.learnlib.api.MembershipOracle;
import de.learnlib.api.Query;
import de.learnlib.counterexamples.LocalSuffixFinder;
import de.learnlib.counterexamples.LocalSuffixFinders;
import de.learnlib.discriminationtree.DTNode;
import de.learnlib.discriminationtree.DiscriminationTree;
import de.learnlib.oracles.DefaultQuery;
import de.learnlib.oracles.MQUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.automatalib.automata.concepts.SuffixOutput;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public abstract class AbstractDTLearner<M extends SuffixOutput<I, O>, I, O, SP, TP>
implements LearningAlgorithm<M, I, O> {
    private final Alphabet<I> alphabet;
    private final MembershipOracle<I, O> oracle;
    private final LocalSuffixFinder<? super I, ? super O> suffixFinder;
    private final boolean repeatedCounterexampleEvaluation;
    protected final DiscriminationTree<I, O, HState<I, O, SP, TP>> dtree;
    protected final DTLearnerHypothesis<I, O, SP, TP> hypothesis;
    private final List<HState<I, O, SP, TP>> newStates = new ArrayList<HState<I, O, SP, TP>>();
    private final List<HTransition<I, O, SP, TP>> newTransitions = new ArrayList<HTransition<I, O, SP, TP>>();
    private final Deque<HTransition<I, O, SP, TP>> openTransitions = new ArrayDeque<HTransition<I, O, SP, TP>>();

    protected AbstractDTLearner(Alphabet<I> alphabet, MembershipOracle<I, O> oracle, LocalSuffixFinder<? super I, ? super O> suffixFinder, boolean repeatedCounterexampleEvaluation, DiscriminationTree<I, O, HState<I, O, SP, TP>> dtree) {
        this.alphabet = alphabet;
        this.oracle = oracle;
        this.suffixFinder = suffixFinder;
        this.hypothesis = new DTLearnerHypothesis(alphabet);
        this.dtree = dtree;
        this.repeatedCounterexampleEvaluation = repeatedCounterexampleEvaluation;
    }

    public boolean refineHypothesis(DefaultQuery<I, O> ceQuery) {
        if (!this.refineHypothesisSingle(ceQuery)) {
            return false;
        }
        if (this.repeatedCounterexampleEvaluation) {
            while (this.refineHypothesisSingle(ceQuery)) {
            }
        }
        return true;
    }

    public void startLearning() {
        Object init = this.hypothesis.getInitialState();
        DTNode<I, O, HState<I, O, SP, TP>> initDt = this.dtree.sift(((HState)init).getAccessSequence());
        if (initDt.getData() != null) {
            throw new IllegalStateException("Decision tree already contains data");
        }
        initDt.setData((HState<I, O, SP, TP>)init);
        ((HState)init).setDTLeaf(initDt);
        this.initializeState((HState<I, O, SP, TP>)init);
        this.updateHypothesis();
    }

    public DiscriminationTree<I, O, HState<I, O, SP, TP>> getDiscriminationTree() {
        return this.dtree;
    }

    public DTLearnerHypothesis<I, O, SP, TP> getHypothesisDS() {
        return this.hypothesis;
    }

    protected boolean refineHypothesisSingle(DefaultQuery<I, O> ceQuery) {
        if (!MQUtil.isCounterexample(ceQuery, (SuffixOutput)((SuffixOutput)this.getHypothesisModel()))) {
            return false;
        }
        int suffixIdx = this.suffixFinder.findSuffixIndex(ceQuery, this.hypothesis, (SuffixOutput)this.getHypothesisModel(), this.oracle);
        if (suffixIdx == -1) {
            throw new AssertionError((Object)"Suffix finder does not work correctly, found no suffix for valid counterexample");
        }
        Word input = ceQuery.getInput();
        Word oldStateAs = input.prefix(suffixIdx);
        HState oldState = (HState)this.hypothesis.getState((Iterable)oldStateAs);
        DTNode oldDt = oldState.getDTLeaf();
        Word newPredAs = input.prefix(suffixIdx - 1);
        HState newPred = (HState)this.hypothesis.getState((Iterable)newPredAs);
        Object transSym = input.getSymbol(suffixIdx - 1);
        int transIdx = this.alphabet.getSymbolIndex(transSym);
        HTransition trans = newPred.getTransition(transIdx);
        HState newState = this.createState(trans);
        Word suffix = input.subWord(suffixIdx);
        Object oldOut = MQUtil.output(this.oracle, oldState.getAccessSequence(), (Word)suffix);
        Object newOut = MQUtil.output(this.oracle, newState.getAccessSequence(), (Word)suffix);
        DTNode.SplitResult sr = oldDt.split(suffix, oldOut, newOut, newState);
        oldState.fetchNonTreeIncoming(this.openTransitions);
        oldState.setDTLeaf(sr.nodeOld);
        newState.setDTLeaf(sr.nodeNew);
        this.updateHypothesis();
        return true;
    }

    protected void initializeState(HState<I, O, SP, TP> newState) {
        this.newStates.add(newState);
        int size = this.alphabet.size();
        for (int i = 0; i < size; ++i) {
            Object sym = this.alphabet.getSymbol(i);
            HTransition<Object, O, SP, TP> newTrans = new HTransition<Object, O, SP, TP>(newState, sym, this.dtree.getRoot());
            newState.setTransition(i, newTrans);
            this.newTransitions.add(newTrans);
            this.openTransitions.offer(newTrans);
        }
    }

    protected HState<I, O, SP, TP> createState(HTransition<I, O, SP, TP> trans) {
        HState<I, O, SP, TP> newState = this.hypothesis.createState(trans);
        this.initializeState(newState);
        return newState;
    }

    protected void updateTransition(HTransition<I, O, SP, TP> trans) {
        if (trans.isTree()) {
            return;
        }
        DTNode<I, O, HState<I, O, SP, TP>> currDt = trans.getDT();
        currDt = this.dtree.sift(currDt, trans.getAccessSequence());
        trans.setDT(currDt);
        HState<I, O, SP, TP> state = currDt.getData();
        if (state == null) {
            state = this.createState(trans);
            currDt.setData(state);
            state.setDTLeaf(currDt);
        } else {
            state.addNonTreeIncoming(trans);
        }
    }

    protected void updateHypothesis() {
        HTransition<I, O, SP, TP> current;
        while ((current = this.openTransitions.poll()) != null) {
            this.updateTransition(current);
        }
        ArrayList<Query<I, O>> queries = new ArrayList<Query<I, O>>();
        for (HState<I, O, SP, TP> hState : this.newStates) {
            Query<I, O> spQuery = this.spQuery(hState);
            if (spQuery == null) continue;
            queries.add(spQuery);
        }
        this.newStates.clear();
        for (HTransition hTransition : this.newTransitions) {
            Query<I, O> tpQuery = this.tpQuery(hTransition);
            if (tpQuery == null) continue;
            queries.add(tpQuery);
        }
        this.newTransitions.clear();
        this.oracle.processQueries(queries);
    }

    protected abstract Query<I, O> spQuery(HState<I, O, SP, TP> var1);

    protected abstract Query<I, O> tpQuery(HTransition<I, O, SP, TP> var1);

    public static class BuilderDefaults {
        public static <I, O> LocalSuffixFinder<? super I, ? super O> suffixFinder() {
            return LocalSuffixFinders.RIVEST_SCHAPIRE;
        }

        public static boolean repeatedCounterexampleEvaluation() {
            return true;
        }
    }
}

