/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.discriminationtree.hypothesis.vpda;

import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.ContextPair;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.DTNode;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.HypLoc;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.datastructure.discriminationtree.model.AbstractDiscriminationTree;
import java.util.List;
import java.util.function.Predicate;
import net.automatalib.words.Word;

public class DTree<I>
extends AbstractDiscriminationTree<ContextPair<I>, I, Boolean, HypLoc<I>, DTNode<I>> {
    public DTree(MembershipOracle<I, Boolean> oracle) {
        super(new DTNode(null, false), oracle);
    }

    public DTNode<I> sift(DTNode<I> start, Word<I> prefix) {
        return this.sift(start, prefix, true);
    }

    public List<DTNode<I>> sift(List<DTNode<I>> starts, List<Word<I>> prefixes) {
        return this.sift(starts, prefixes, true);
    }

    public DTNode<I> sift(DTNode<I> start, Word<I> as, boolean hard) {
        return (DTNode)super.sift(start, as, DTree.getSiftPredicate(hard));
    }

    public List<DTNode<I>> sift(List<DTNode<I>> starts, List<Word<I>> prefixes, boolean hard) {
        return super.sift(starts, prefixes, DTree.getSiftPredicate(hard));
    }

    protected DefaultQuery<I, Boolean> buildQuery(DTNode<I> node, Word<I> prefix) {
        ContextPair discr = (ContextPair)node.getDiscriminator();
        Word completePrefix = discr.getPrefix().concat(new Word[]{prefix});
        return new DefaultQuery(completePrefix, ((ContextPair)node.getDiscriminator()).getSuffix());
    }

    private static <I> Predicate<DTNode<I>> getSiftPredicate(boolean hard) {
        return n -> n.isInner() && (hard || !n.isTemp());
    }
}

