/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.discriminationtree.hypothesis.vpda;

import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.DTNode;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.HypLoc;
import de.learnlib.api.AccessSequenceProvider;
import de.learnlib.datastructure.list.IntrusiveListElemImpl;
import net.automatalib.words.Word;

public abstract class AbstractHypTrans<I>
extends IntrusiveListElemImpl<AbstractHypTrans<I>>
implements AccessSequenceProvider<I> {
    private final Word<I> aseq;
    protected IntrusiveListElemImpl<AbstractHypTrans<I>> prev;
    private HypLoc<I> treeTarget;
    private DTNode<I> nonTreeTarget;

    public AbstractHypTrans(Word<I> aseq) {
        this.aseq = aseq;
    }

    public HypLoc<I> getTreeTarget() {
        assert (this.isTree());
        return this.treeTarget;
    }

    public boolean isTree() {
        return this.treeTarget != null;
    }

    public HypLoc<I> getTargetLocation() {
        if (this.treeTarget != null) {
            return this.treeTarget;
        }
        assert (this.nonTreeTarget.isLeaf()) : "transition does not point to a leaf";
        assert (this.nonTreeTarget.getData() != null);
        return (HypLoc)this.nonTreeTarget.getData();
    }

    public DTNode<I> getNonTreeTarget() {
        assert (!this.isTree());
        return this.nonTreeTarget;
    }

    public void setNonTreeTarget(DTNode<I> nonTreeTarget) {
        assert (!this.isTree());
        this.nonTreeTarget = nonTreeTarget;
    }

    public DTNode<I> getTargetNode() {
        if (this.treeTarget != null) {
            return this.treeTarget.getLeaf();
        }
        return this.nonTreeTarget;
    }

    public Word<I> getAccessSequence() {
        return this.aseq;
    }

    public void makeTree(HypLoc<I> tgtLoc) {
        assert (!this.isTree());
        this.treeTarget = tgtLoc;
        this.nonTreeTarget = null;
        this.removeFromList();
    }

    public void removeFromList() {
        if (this.next != null) {
            ((AbstractHypTrans)((Object)this.next)).prev = this.prev;
        }
        if (this.prev != null) {
            this.prev.setNextElement(this.next);
        }
        this.prev = null;
        this.next = null;
    }
}

