/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.discriminationtree.vpda;

import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.AbstractHypTrans;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.ContextPair;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.DTNode;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.DTree;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.HypIntTrans;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.HypLoc;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.HypRetTrans;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.OneSEVPAHypothesis;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.TransList;
import de.learnlib.api.AccessSequenceProvider;
import de.learnlib.api.algorithm.LearningAlgorithm;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.api.query.DefaultQuery;
import de.learnlib.datastructure.discriminationtree.model.AbstractDTNode;
import java.util.Iterator;
import net.automatalib.automata.vpda.OneSEVPA;
import net.automatalib.commons.smartcollections.ElementReference;
import net.automatalib.commons.smartcollections.UnorderedCollection;
import net.automatalib.words.VPDAlphabet;
import net.automatalib.words.Word;

public abstract class AbstractVPDALearner<I>
implements LearningAlgorithm<OneSEVPA<?, I>, I, Boolean> {
    protected final VPDAlphabet<I> alphabet;
    protected final MembershipOracle<I, Boolean> oracle;
    protected final DTree<I> dtree;
    protected final OneSEVPAHypothesis<I> hypothesis;
    protected final TransList<I> openTransitions = new TransList();

    public AbstractVPDALearner(VPDAlphabet<I> alphabet, MembershipOracle<I, Boolean> oracle) {
        this.alphabet = alphabet;
        this.oracle = oracle;
        this.dtree = new DTree<I>(oracle);
        ((DTNode)this.dtree.getRoot()).split(new ContextPair(Word.epsilon(), Word.epsilon()), false, true);
        this.hypothesis = new OneSEVPAHypothesis<I>(alphabet);
    }

    public void startLearning() {
        HypLoc<I> initLoc = this.hypothesis.initialize();
        DTNode<I> leaf = this.dtree.sift(initLoc);
        AbstractVPDALearner.link(leaf, initLoc);
        this.initializeLocation(initLoc);
        this.closeTransitions();
    }

    public boolean refineHypothesis(DefaultQuery<I, Boolean> ceQuery) {
        if (this.hypothesis.computeSuffixOutput((Iterable)ceQuery.getPrefix(), (Iterable)ceQuery.getSuffix()).equals(ceQuery.getOutput())) {
            return false;
        }
        while (this.refineHypothesisSingle(ceQuery)) {
        }
        return true;
    }

    protected abstract boolean refineHypothesisSingle(DefaultQuery<I, Boolean> var1);

    public OneSEVPA<?, I> getHypothesisModel() {
        return this.hypothesis;
    }

    protected static <I> void link(DTNode<I> leaf, HypLoc<I> loc) {
        assert (leaf.isLeaf());
        leaf.setData(loc);
        loc.setLeaf(leaf);
    }

    protected void initializeLocation(HypLoc<I> loc) {
        int i;
        assert (loc.getLeaf() != null);
        loc.setAccepting((Boolean)((DTNode)this.dtree.getRoot()).subtreeLabel((AbstractDTNode)loc.getLeaf()));
        for (i = 0; i < this.alphabet.getNumInternals(); ++i) {
            Object intSym = this.alphabet.getInternalSymbol(i);
            HypIntTrans<Object> trans = new HypIntTrans<Object>(loc, intSym);
            loc.setInternalTransition(i, trans);
            this.openTransitions.add(trans);
        }
        loc.updateStackAlphabetSize(this.hypothesis.getNumStackSymbols());
        for (i = 0; i < this.alphabet.getNumCalls(); ++i) {
            Object callSym = this.alphabet.getCallSymbol(i);
            int myStackSym = this.hypothesis.encodeStackSym(loc, i);
            for (HypLoc<Object> hypLoc : this.hypothesis.getLocations()) {
                hypLoc.updateStackAlphabetSize(this.hypothesis.getNumStackSymbols());
                int stackSym = this.hypothesis.encodeStackSym(hypLoc, i);
                for (int j = 0; j < this.alphabet.getNumReturns(); ++j) {
                    Object retSym = this.alphabet.getReturnSymbol(j);
                    HypRetTrans<Object> trans = new HypRetTrans<Object>(loc, retSym, callSym, hypLoc);
                    loc.setReturnTransition(j, stackSym, trans);
                    this.openTransitions.add(trans);
                    if (loc == hypLoc) continue;
                    HypRetTrans<Object> retTrans = new HypRetTrans<Object>(hypLoc, retSym, callSym, loc);
                    hypLoc.setReturnTransition(j, myStackSym, retTrans);
                    this.openTransitions.add(retTrans);
                }
            }
        }
    }

    protected void closeTransitions() {
        UnorderedCollection newStateNodes = new UnorderedCollection();
        while (true) {
            AbstractHypTrans<I> next;
            if ((next = this.openTransitions.poll()) != null) {
                DTNode<I> newStateNode = this.closeTransition(next, false);
                if (newStateNode == null) continue;
                newStateNodes.add(newStateNode);
                continue;
            }
            if (!newStateNodes.isEmpty()) {
                this.addNewStates(newStateNodes);
            }
            if (this.openTransitions.isEmpty()) break;
        }
    }

    private DTNode<I> closeTransition(AbstractHypTrans<I> trans, boolean hard) {
        if (trans.isTree()) {
            return null;
        }
        DTNode<I> node = this.updateDTTarget(trans, hard);
        if (node.isLeaf() && node.getData() == null && trans.getNextElement() == null) {
            return node;
        }
        return null;
    }

    private void addNewStates(UnorderedCollection<DTNode<I>> newStateNodes) {
        DTNode minTransNode = null;
        AbstractHypTrans minTrans = null;
        int minAsLen = Integer.MAX_VALUE;
        ElementReference minTransNodeRef = null;
        for (ElementReference ref : newStateNodes.references()) {
            DTNode newStateNode = (DTNode)((Object)newStateNodes.get(ref));
            Iterator iterator = newStateNode.getIncoming().iterator();
            while (iterator.hasNext()) {
                AbstractHypTrans trans = (AbstractHypTrans)((Object)iterator.next());
                Word as = trans.getAccessSequence();
                int asLen = as.length();
                if (asLen >= minAsLen) continue;
                minTransNode = newStateNode;
                minTrans = trans;
                minAsLen = asLen;
                minTransNodeRef = ref;
            }
        }
        assert (minTransNode != null);
        newStateNodes.remove(minTransNodeRef);
        assert (minTrans.getNonTreeTarget().getData() == null);
        HypLoc<I> newLoc = this.makeTree(minTrans);
        AbstractVPDALearner.link(minTransNode, newLoc);
        this.initializeLocation(newLoc);
    }

    protected DTNode<I> updateDTTarget(AbstractHypTrans<I> trans, boolean hard) {
        if (trans.isTree()) {
            return trans.getTargetNode();
        }
        DTNode start = trans.getNonTreeTarget();
        if (start == null) {
            trans.setNonTreeTarget((DTNode)this.dtree.getRoot());
            start = (DTNode)this.dtree.getRoot();
        }
        DTNode<I> result = this.dtree.sift(start, trans, hard);
        trans.setNonTreeTarget(result);
        result.addIncoming(trans);
        return result;
    }

    protected HypLoc<I> makeTree(AbstractHypTrans<I> trans) {
        assert (!trans.isTree());
        HypLoc<I> newLoc = this.createLocation(trans);
        trans.makeTree(newLoc);
        return newLoc;
    }

    protected HypLoc<I> createLocation(AbstractHypTrans<I> trans) {
        return this.hypothesis.createLocation(false, trans);
    }

    protected HypLoc<I> createLocation(Word<I> as) {
        return this.hypothesis.createLocation(false, as);
    }

    protected Boolean query(AccessSequenceProvider<I> asp, ContextPair<I> context) {
        return (Boolean)this.oracle.answerQuery(context.getPrefix().concat(new Word[]{asp.getAccessSequence()}), context.getSuffix());
    }
}

