/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.discriminationtree.hypothesis.vpda;

import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.AbstractHypTrans;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.HypLoc;
import java.util.ArrayList;
import java.util.List;
import net.automatalib.automata.vpda.AbstractOneSEVPA;
import net.automatalib.automata.vpda.State;
import net.automatalib.words.VPDAlphabet;
import net.automatalib.words.Word;

public class OneSEVPAHypothesis<I>
extends AbstractOneSEVPA<HypLoc<I>, I> {
    private final List<HypLoc<I>> locations = new ArrayList<HypLoc<I>>();
    private HypLoc<I> initLoc;

    public OneSEVPAHypothesis(VPDAlphabet<I> alphabet) {
        super(alphabet);
    }

    public AbstractHypTrans<I> getInternalTransition(State<HypLoc<I>> state, I sym) {
        switch (this.alphabet.getSymbolType(sym)) {
            case INTERNAL: {
                return ((HypLoc)state.getLocation()).getInternalTransition(this.alphabet.getInternalSymbolIndex(sym));
            }
            case RETURN: {
                return ((HypLoc)state.getLocation()).getReturnTransition(this.alphabet.getReturnSymbolIndex(sym), state.getStackContents().peek());
            }
        }
        return null;
    }

    public AbstractHypTrans<I> getInternalTransition(HypLoc<I> loc, I intSym) {
        return loc.getInternalTransition(this.alphabet.getInternalSymbolIndex(intSym));
    }

    public AbstractHypTrans<I> getReturnTransition(HypLoc<I> loc, I retSym, int stackSym) {
        return loc.getReturnTransition(this.alphabet.getReturnSymbolIndex(retSym), stackSym);
    }

    public AbstractHypTrans<I> getReturnTransition(HypLoc<I> loc, I retSym, HypLoc<I> stackLoc, I callSym) {
        int stackSym = this.encodeStackSym(stackLoc, callSym);
        return loc.getReturnTransition(this.alphabet.getReturnSymbolIndex(retSym), stackSym);
    }

    public HypLoc<I> createLocation(boolean accepting, Word<I> aseq) {
        HypLoc<I> loc = new HypLoc<I>(this.alphabet, this.locations.size(), accepting, aseq);
        this.locations.add(loc);
        return loc;
    }

    public HypLoc<I> createLocation(boolean accepting, AbstractHypTrans<I> treeIncoming) {
        HypLoc<I> loc = new HypLoc<I>(this.alphabet, this.locations.size(), accepting, treeIncoming);
        this.locations.add(loc);
        return loc;
    }

    public HypLoc<I> initialize() {
        HypLoc<I> loc = this.createLocation(false, (AbstractHypTrans)null);
        this.initLoc = loc;
        return loc;
    }

    public HypLoc<I> getInternalSuccessor(HypLoc<I> loc, I intSym) {
        return loc.getInternalTransition(this.alphabet.getInternalSymbolIndex(intSym)).getTargetLocation();
    }

    public HypLoc<I> getLocation(int id) {
        return this.locations.get(id);
    }

    public int getLocationId(HypLoc<I> loc) {
        return loc.index;
    }

    public List<HypLoc<I>> getLocations() {
        return this.locations;
    }

    public HypLoc<I> getReturnSuccessor(HypLoc<I> loc, I retSym, int stackSym) {
        return loc.getReturnTransition(this.alphabet.getReturnSymbolIndex(retSym), stackSym).getTargetLocation();
    }

    public boolean isAcceptingLocation(HypLoc<I> loc) {
        return loc.isAccepting();
    }

    public HypLoc<I> getInitialLocation() {
        return this.initLoc;
    }

    public int size() {
        return this.locations.size();
    }
}

