/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.discriminationtree.hypothesis.vpda;

import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.ContextPair;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.DTNode;
import de.learnlib.algorithms.discriminationtree.hypothesis.vpda.HypLoc;
import de.learnlib.api.AccessSequenceProvider;
import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.datastructure.discriminationtree.model.AbstractDiscriminationTree;
import net.automatalib.words.Word;

public class DTree<I>
extends AbstractDiscriminationTree<ContextPair<I>, I, Boolean, HypLoc<I>, DTNode<I>> {
    public DTree(MembershipOracle<I, Boolean> oracle) {
        super(new DTNode(null, false), oracle);
    }

    public DTree(DTNode<I> root, MembershipOracle<I, Boolean> oracle) {
        super(root, oracle);
    }

    public DTNode<I> sift(DTNode<I> start, Word<I> prefix) {
        return this.sift(start, prefix, true);
    }

    public DTNode<I> sift(DTNode<I> start, Word<I> as, boolean hard) {
        DTNode curr = start;
        while (curr.isInner() && (hard || !curr.isTemp())) {
            ContextPair discr = (ContextPair)curr.getDiscriminator();
            Word prefix = discr.getPrefix().concat(new Word[]{as});
            Boolean outcome = (Boolean)this.oracle.answerQuery(prefix, discr.getSuffix());
            curr = (DTNode)curr.getChild(outcome);
        }
        return curr;
    }

    public DTNode<I> sift(AccessSequenceProvider<I> asp) {
        return this.sift((DTNode)this.getRoot(), asp, false);
    }

    public DTNode<I> sift(DTNode<I> start, AccessSequenceProvider<I> asp, boolean hard) {
        return this.sift(start, asp.getAccessSequence(), hard);
    }
}

