/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.dhc.mealy;

import de.learnlib.algorithms.dhc.Deduplicator;
import de.learnlib.api.AccessSequenceTransformer;
import de.learnlib.api.LearningAlgorithm;
import de.learnlib.api.MembershipOracle;
import de.learnlib.counterexamples.GlobalSuffixFinder;
import de.learnlib.counterexamples.GlobalSuffixFinders;
import de.learnlib.oracles.DefaultQuery;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.automatalib.automata.transout.MealyMachine;
import net.automatalib.automata.transout.impl.compact.CompactMealy;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;
import net.automatalib.words.impl.SimpleAlphabet;

public class MealyDHC<I, O>
implements LearningAlgorithm.MealyLearner<I, O>,
AccessSequenceTransformer<I> {
    private static final Logger log = Logger.getLogger(MealyDHC.class.getName());
    private Alphabet<I> alphabet;
    private MembershipOracle<I, Word<O>> oracle;
    private SimpleAlphabet<Word<I>> splitters = new SimpleAlphabet();
    private CompactMealy<I, O> hypothesis;
    private MutableMapping<Integer, QueueElement<I, O>> accessSequences;
    private GlobalSuffixFinder<? super I, ? super Word<O>> suffixFinder;

    public MealyDHC(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle) {
        this.alphabet = alphabet;
        this.oracle = oracle;
        this.suffixFinder = GlobalSuffixFinders.RIVEST_SCHAPIRE;
    }

    public void startLearning() {
        ArrayList<Object> effectivealpha = new ArrayList<Object>();
        for (Object input : this.alphabet) {
            effectivealpha.add(Word.fromLetter(input));
        }
        effectivealpha.addAll((Collection<Object>)this.splitters);
        HashMap<ArrayList<Word<O>>, Integer> signatures = new HashMap<ArrayList<Word<O>>, Integer>();
        this.hypothesis = new CompactMealy(this.alphabet);
        LinkedList<QueueElement<I, O>> queue = new LinkedList<QueueElement<I, O>>();
        this.accessSequences = this.hypothesis.createDynamicStateMapping();
        queue.add(new QueueElement(null, null, null, null));
        Deduplicator<Object> deduplicator = new Deduplicator<Object>();
        while (!queue.isEmpty()) {
            Integer state;
            QueueElement elem = (QueueElement)queue.poll();
            Word<I> access = this.assembleAccessSequence(elem);
            ArrayList<DefaultQuery> queries = new ArrayList<DefaultQuery>(effectivealpha.size());
            for (Word suffix : effectivealpha) {
                queries.add(new DefaultQuery(access, suffix));
            }
            this.oracle.processQueries(queries);
            ArrayList<Word<O>> sig = new ArrayList<Word<O>>(effectivealpha.size());
            for (DefaultQuery query : queries) {
                sig.add((Word<O>)deduplicator.deduplicate(query.getOutput()));
            }
            Integer sibling = (Integer)signatures.get(sig);
            if (sibling != null) {
                this.hypothesis.addTransition((Object)elem.parentState, elem.transIn, (Object)sibling, elem.transOut);
                continue;
            }
            Integer n = state = elem.parentElement == null ? (Integer)this.hypothesis.addInitialState() : (Integer)this.hypothesis.addState();
            if (elem.parentElement != null) {
                this.hypothesis.addTransition((Object)elem.parentState, elem.transIn, (Object)state, elem.transOut);
            }
            signatures.put(sig, state);
            this.accessSequences.put((Object)state, (Object)elem);
            this.scheduleSuccessors(elem, state, queue, sig);
        }
    }

    private Word<I> assembleAccessSequence(QueueElement<I, O> elem) {
        ArrayList<Object> word = new ArrayList<Object>(((QueueElement)elem).depth);
        QueueElement pre = ((QueueElement)elem).parentElement;
        Object sym = ((QueueElement)elem).transIn;
        while (pre != null && sym != null) {
            word.add(sym);
            sym = pre.transIn;
            pre = pre.parentElement;
        }
        Collections.reverse(word);
        return Word.fromList(word);
    }

    private void scheduleSuccessors(QueueElement<I, O> elem, Integer state, Queue<QueueElement<I, O>> queue, List<Word<O>> sig) throws IllegalArgumentException {
        for (int i = 0; i < this.alphabet.size(); ++i) {
            Object input = this.alphabet.getSymbol(i);
            Object output = sig.get(i).getSymbol(0);
            queue.add(new QueueElement(state, elem, input, output));
        }
    }

    private void checkInternalState() {
        if (this.hypothesis == null) {
            throw new IllegalStateException("No hypothesis learned yet");
        }
    }

    public boolean refineHypothesis(DefaultQuery<I, Word<O>> ceQuery) {
        this.checkInternalState();
        int oldsize = this.hypothesis.size();
        for (Word suf : this.suffixFinder.findSuffixes(ceQuery, (AccessSequenceTransformer)this, this.hypothesis, this.oracle)) {
            if (this.splitters.contains((Object)suf)) continue;
            this.splitters.add((Object)suf);
            log.log(Level.FINE, "added suffix: {0}", suf);
        }
        this.startLearning();
        return oldsize != this.hypothesis.size();
    }

    public MealyMachine<?, I, ?, O> getHypothesisModel() {
        this.checkInternalState();
        return this.hypothesis;
    }

    public Word<I> transformAccessSequence(Word<I> word) {
        this.checkInternalState();
        Integer state = (Integer)this.hypothesis.getSuccessor((Object)this.hypothesis.getInitialState(), word);
        return this.assembleAccessSequence((QueueElement)this.accessSequences.get((Object)state));
    }

    public boolean isAccessSequence(Word<I> word) {
        this.checkInternalState();
        Word<I> canonical = this.transformAccessSequence(word);
        return canonical.equals(word);
    }

    private static class QueueElement<I, O> {
        private Integer parentState;
        private QueueElement<I, O> parentElement;
        private I transIn;
        private O transOut;
        private int depth;

        private QueueElement(Integer parentState, QueueElement<I, O> parentElement, I transIn, O transOut) {
            this.parentState = parentState;
            this.parentElement = parentElement;
            this.transIn = transIn;
            this.transOut = transOut;
            this.depth = parentElement != null ? parentElement.depth + 1 : 0;
        }
    }
}

