/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithm.dhc.mealy;

import de.learnlib.AccessSequenceTransformer;
import de.learnlib.Resumable;
import de.learnlib.algorithm.GlobalSuffixLearner;
import de.learnlib.algorithm.LearningAlgorithm;
import de.learnlib.algorithm.dhc.mealy.MealyDHCState;
import de.learnlib.counterexample.GlobalSuffixFinder;
import de.learnlib.counterexample.GlobalSuffixFinders;
import de.learnlib.oracle.MembershipOracle;
import de.learnlib.query.DefaultQuery;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import net.automatalib.alphabet.Alphabet;
import net.automatalib.alphabet.SupportsGrowingAlphabet;
import net.automatalib.automaton.transducer.impl.CompactMealy;
import net.automatalib.common.util.HashUtil;
import net.automatalib.common.util.mapping.MapMapping;
import net.automatalib.common.util.mapping.MutableMapping;
import net.automatalib.word.Word;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MealyDHC<I, O>
implements LearningAlgorithm.MealyLearner<I, O>,
AccessSequenceTransformer<I>,
GlobalSuffixLearner.GlobalSuffixLearnerMealy<I, O>,
SupportsGrowingAlphabet<I>,
Resumable<MealyDHCState<I, O>> {
    private final MembershipOracle<I, Word<O>> oracle;
    private final Alphabet<I> alphabet;
    private Set<Word<I>> splitters = new LinkedHashSet<Word<I>>();
    private CompactMealy<I, O> hypothesis;
    private MutableMapping<Integer, QueueElement<I, O>> accessSequences;
    private final GlobalSuffixFinder<? super I, ? super Word<O>> suffixFinder;

    public MealyDHC(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle) {
        this(alphabet, oracle, GlobalSuffixFinders.RIVEST_SCHAPIRE, Collections.emptyList());
    }

    public MealyDHC(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle, GlobalSuffixFinder<? super I, ? super Word<O>> suffixFinder, Collection<? extends Word<I>> initialSplitters) {
        this.alphabet = alphabet;
        this.oracle = oracle;
        this.suffixFinder = suffixFinder;
        for (Object symbol : alphabet) {
            this.splitters.add(Word.fromLetter(symbol));
        }
        if (initialSplitters != null) {
            this.splitters.addAll(initialSplitters);
        }
    }

    public Collection<Word<I>> getGlobalSuffixes() {
        return Collections.unmodifiableCollection(this.splitters);
    }

    public boolean addGlobalSuffixes(Collection<? extends Word<I>> newGlobalSuffixes) {
        this.checkInternalState();
        return this.addSuffixesUnchecked(newGlobalSuffixes);
    }

    private void checkInternalState() {
        if (this.hypothesis == null) {
            throw new IllegalStateException("No hypothesis learned yet");
        }
    }

    protected boolean addSuffixesUnchecked(Collection<? extends Word<I>> newSuffixes) {
        int oldSize = this.hypothesis.size();
        this.splitters.addAll(newSuffixes);
        this.startLearning();
        return this.hypothesis.size() != oldSize;
    }

    public void startLearning() {
        HashMap<ArrayList<Word<O>>, Integer> signatures = new HashMap<ArrayList<Word<O>>, Integer>();
        this.hypothesis = new CompactMealy(this.alphabet);
        ArrayDeque<QueueElement<I, O>> queue = new ArrayDeque<QueueElement<I, O>>();
        this.accessSequences = this.hypothesis.createDynamicStateMapping();
        queue.add(new QueueElement<Object, Object>(null, null, null, null));
        while (!queue.isEmpty()) {
            Integer state;
            @NonNull QueueElement elem = (QueueElement)queue.poll();
            Word<I> access = this.assembleAccessSequence(elem);
            ArrayList<DefaultQuery> queries = new ArrayList<DefaultQuery>(this.splitters.size());
            for (Word<I> word : this.splitters) {
                queries.add(new DefaultQuery(access, word));
            }
            this.oracle.processQueries(queries);
            ArrayList<Word<O>> sig = new ArrayList<Word<O>>(this.splitters.size());
            for (DefaultQuery query : queries) {
                sig.add((Word)query.getOutput());
            }
            Integer n = (Integer)signatures.get(sig);
            if (n != null) {
                this.hypothesis.addTransition((Object)elem.parentState, elem.transIn, (Object)n, elem.transOut);
                continue;
            }
            Integer n2 = state = elem.parentElement == null ? (Integer)this.hypothesis.addInitialState() : (Integer)this.hypothesis.addState();
            if (elem.parentElement != null) {
                this.hypothesis.addTransition((Object)elem.parentState, elem.transIn, (Object)state, elem.transOut);
            }
            signatures.put(sig, state);
            this.accessSequences.put((Object)state, (Object)elem);
            this.scheduleSuccessors(elem, state, queue, sig);
        }
    }

    private Word<I> assembleAccessSequence(QueueElement<I, O> elem) {
        ArrayList<Object> word = new ArrayList<Object>(((QueueElement)elem).depth);
        QueueElement pre = ((QueueElement)elem).parentElement;
        Object sym = ((QueueElement)elem).transIn;
        while (pre != null && sym != null) {
            word.add(sym);
            sym = pre.transIn;
            pre = pre.parentElement;
        }
        Collections.reverse(word);
        return Word.fromList(word);
    }

    private void scheduleSuccessors(QueueElement<I, O> elem, Integer state, Queue<QueueElement<I, O>> queue, List<Word<O>> sig) {
        for (int i = 0; i < this.alphabet.size(); ++i) {
            Object input = this.alphabet.getSymbol(i);
            Object output = sig.get(i).getSymbol(0);
            queue.add(new QueueElement<Object, Object>(state, elem, input, output));
        }
    }

    public boolean refineHypothesis(DefaultQuery<I, Word<O>> ceQuery) {
        this.checkInternalState();
        if (((Word)this.hypothesis.computeSuffixOutput((Iterable)ceQuery.getPrefix(), (Iterable)ceQuery.getSuffix())).equals(ceQuery.getOutput())) {
            return false;
        }
        List ceSuffixes = this.suffixFinder.findSuffixes(ceQuery, (AccessSequenceTransformer)this, this.hypothesis, this.oracle);
        return this.addSuffixesUnchecked(ceSuffixes);
    }

    public CompactMealy<I, O> getHypothesisModel() {
        this.checkInternalState();
        return this.hypothesis;
    }

    public void addAlphabetSymbol(I symbol) {
        if (!this.alphabet.containsSymbol(symbol)) {
            this.alphabet.asGrowingAlphabetOrThrowException().addSymbol(symbol);
        }
        if (!this.splitters.contains(Word.fromLetter(symbol))) {
            Iterator<Word<I>> splitterIterator = this.splitters.iterator();
            LinkedHashSet<Word<I>> newSplitters = new LinkedHashSet<Word<I>>(HashUtil.capacity((int)(this.splitters.size() + 1)));
            for (int i = 0; i < this.alphabet.size() - 1; ++i) {
                newSplitters.add(splitterIterator.next());
            }
            newSplitters.add(Word.fromLetter(symbol));
            while (splitterIterator.hasNext()) {
                newSplitters.add(splitterIterator.next());
            }
            this.splitters = newSplitters;
            this.startLearning();
        }
    }

    public MealyDHCState<I, O> suspend() {
        return new MealyDHCState<I, O>(this.splitters, this.hypothesis, this.accessSequences);
    }

    public void resume(MealyDHCState<I, O> state) {
        this.splitters = state.getSplitters();
        this.accessSequences = new MapMapping(state.getAccessSequences());
        this.hypothesis = state.getHypothesis();
    }

    public Word<I> transformAccessSequence(Word<I> word) {
        this.checkInternalState();
        Integer state = (Integer)this.hypothesis.getSuccessor((Object)this.hypothesis.getInitialState(), word);
        return this.assembleAccessSequence((QueueElement)this.accessSequences.get((Object)state));
    }

    static final class QueueElement<I, O> {
        private final @Nullable Integer parentState;
        private final @Nullable QueueElement<I, O> parentElement;
        private final @Nullable I transIn;
        private final @Nullable O transOut;
        private final int depth;

        QueueElement(@Nullable Integer parentState, @Nullable QueueElement<I, O> parentElement, @Nullable I transIn, @Nullable O transOut) {
            this.parentState = parentState;
            this.parentElement = parentElement;
            this.transIn = transIn;
            this.transOut = transOut;
            this.depth = parentElement != null ? parentElement.depth + 1 : 0;
        }
    }

    static final class BuilderDefaults {
        private BuilderDefaults() {
        }

        public static <I, O> GlobalSuffixFinder<? super I, ? super Word<O>> suffixFinder() {
            return GlobalSuffixFinders.RIVEST_SCHAPIRE;
        }

        public static <I> Collection<Word<I>> initialSplitters() {
            return Collections.emptyList();
        }
    }
}

