/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.dhc.mealy;

import com.google.common.collect.Maps;
import de.learnlib.algorithms.dhc.mealy.MealyDHC;
import java.io.Serializable;
import java.util.LinkedHashSet;
import java.util.Map;
import net.automatalib.automata.transducers.impl.compact.CompactMealy;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.words.Word;

public class MealyDHCState<I, O>
implements Serializable {
    private final LinkedHashSet<Word<I>> splitters;
    private final CompactMealy<I, O> hypothesis;
    private final Map<Integer, MealyDHC.QueueElement<I, O>> accessSequences;

    MealyDHCState(LinkedHashSet<Word<I>> splitters, CompactMealy<I, O> hypothesis, MutableMapping<Integer, MealyDHC.QueueElement<I, O>> accessSequences) {
        this.splitters = splitters;
        this.hypothesis = hypothesis;
        this.accessSequences = Maps.newHashMapWithExpectedSize((int)hypothesis.size());
        for (Integer s : hypothesis.getStates()) {
            MealyDHC.QueueElement elem = (MealyDHC.QueueElement)accessSequences.get((Object)s);
            if (elem == null) continue;
            this.accessSequences.put(s, elem);
        }
    }

    LinkedHashSet<Word<I>> getSplitters() {
        return this.splitters;
    }

    CompactMealy<I, O> getHypothesis() {
        return this.hypothesis;
    }

    Map<Integer, MealyDHC.QueueElement<I, O>> getAccessSequences() {
        return this.accessSequences;
    }
}

