/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.algorithms.dhc.mealy;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import de.learnlib.algorithms.features.globalsuffixes.GlobalSuffixLearner;
import de.learnlib.api.AccessSequenceTransformer;
import de.learnlib.api.LearningAlgorithm;
import de.learnlib.api.MembershipOracle;
import de.learnlib.counterexamples.GlobalSuffixFinder;
import de.learnlib.counterexamples.GlobalSuffixFinders;
import de.learnlib.oracles.DefaultQuery;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.automatalib.automata.transout.impl.compact.CompactMealy;
import net.automatalib.commons.util.mappings.MutableMapping;
import net.automatalib.words.Alphabet;
import net.automatalib.words.Word;

public class MealyDHC<I, O>
implements LearningAlgorithm.MealyLearner<I, O>,
AccessSequenceTransformer<I>,
GlobalSuffixLearner.GlobalSuffixLearnerMealy<I, O> {
    private static final Logger log = Logger.getLogger(MealyDHC.class.getName());
    private final Alphabet<I> alphabet;
    private final MembershipOracle<I, Word<O>> oracle;
    private LinkedHashSet<Word<I>> splitters = new LinkedHashSet();
    private CompactMealy<I, O> hypothesis;
    private MutableMapping<Integer, QueueElement<I, O>> accessSequences;
    private GlobalSuffixFinder<? super I, ? super Word<O>> suffixFinder;

    public MealyDHC(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle) {
        this(alphabet, oracle, GlobalSuffixFinders.RIVEST_SCHAPIRE, null);
    }

    public MealyDHC(Alphabet<I> alphabet, MembershipOracle<I, Word<O>> oracle, GlobalSuffixFinder<? super I, ? super Word<O>> suffixFinder, Collection<? extends Word<I>> initialSplitters) {
        this.alphabet = alphabet;
        this.oracle = oracle;
        this.suffixFinder = suffixFinder;
        if (initialSplitters == null || initialSplitters.isEmpty()) {
            for (Object symbol : alphabet) {
                this.splitters.add(Word.fromLetter(symbol));
            }
        } else {
            this.splitters.addAll(initialSplitters);
        }
    }

    public void startLearning() {
        HashMap<ArrayList<Word<O>>, Integer> signatures = new HashMap<ArrayList<Word<O>>, Integer>();
        this.hypothesis = new CompactMealy(this.alphabet);
        ArrayDeque<QueueElement<I, O>> queue = new ArrayDeque<QueueElement<I, O>>();
        this.accessSequences = this.hypothesis.createDynamicStateMapping();
        queue.add(new QueueElement(null, null, null, null));
        Interner deduplicator = Interners.newStrongInterner();
        while (!queue.isEmpty()) {
            Integer state;
            QueueElement elem = (QueueElement)queue.poll();
            Word<I> access = this.assembleAccessSequence(elem);
            ArrayList<DefaultQuery> queries = new ArrayList<DefaultQuery>(this.splitters.size());
            for (Word word : this.splitters) {
                queries.add(new DefaultQuery(access, word));
            }
            this.oracle.processQueries(queries);
            ArrayList<Word<O>> sig = new ArrayList<Word<O>>(this.splitters.size());
            for (DefaultQuery query : queries) {
                sig.add((Word<O>)deduplicator.intern(query.getOutput()));
            }
            Integer n = (Integer)signatures.get(sig);
            if (n != null) {
                this.hypothesis.addTransition((Object)elem.parentState, elem.transIn, (Object)n, elem.transOut);
                continue;
            }
            Integer n2 = state = elem.parentElement == null ? (Integer)this.hypothesis.addInitialState() : (Integer)this.hypothesis.addState();
            if (elem.parentElement != null) {
                this.hypothesis.addTransition((Object)elem.parentState, elem.transIn, (Object)state, elem.transOut);
            }
            signatures.put(sig, state);
            this.accessSequences.put((Object)state, (Object)elem);
            this.scheduleSuccessors(elem, state, queue, sig);
        }
    }

    private Word<I> assembleAccessSequence(QueueElement<I, O> elem) {
        ArrayList<Object> word = new ArrayList<Object>(((QueueElement)elem).depth);
        QueueElement pre = ((QueueElement)elem).parentElement;
        Object sym = ((QueueElement)elem).transIn;
        while (pre != null && sym != null) {
            word.add(sym);
            sym = pre.transIn;
            pre = pre.parentElement;
        }
        Collections.reverse(word);
        return Word.fromList(word);
    }

    private void scheduleSuccessors(QueueElement<I, O> elem, Integer state, Queue<QueueElement<I, O>> queue, List<Word<O>> sig) throws IllegalArgumentException {
        for (int i = 0; i < this.alphabet.size(); ++i) {
            Object input = this.alphabet.getSymbol(i);
            Object output = sig.get(i).getSymbol(0);
            queue.add(new QueueElement(state, elem, input, output));
        }
    }

    private void checkInternalState() {
        if (this.hypothesis == null) {
            throw new IllegalStateException("No hypothesis learned yet");
        }
    }

    public boolean refineHypothesis(DefaultQuery<I, Word<O>> ceQuery) {
        this.checkInternalState();
        List ceSuffixes = this.suffixFinder.findSuffixes(ceQuery, (AccessSequenceTransformer)this, this.hypothesis, this.oracle);
        return this.addSuffixesUnchecked(ceSuffixes);
    }

    public CompactMealy<I, O> getHypothesisModel() {
        this.checkInternalState();
        return this.hypothesis;
    }

    public Word<I> transformAccessSequence(Word<I> word) {
        this.checkInternalState();
        Integer state = (Integer)this.hypothesis.getSuccessor((Object)this.hypothesis.getInitialState(), word);
        return this.assembleAccessSequence((QueueElement)this.accessSequences.get((Object)state));
    }

    public boolean isAccessSequence(Word<I> word) {
        this.checkInternalState();
        Word<I> canonical = this.transformAccessSequence(word);
        return canonical.equals(word);
    }

    public Collection<? extends Word<I>> getGlobalSuffixes() {
        return Collections.unmodifiableCollection(this.splitters);
    }

    public boolean addGlobalSuffixes(Collection<? extends Word<I>> newGlobalSuffixes) {
        this.checkInternalState();
        return this.addSuffixesUnchecked(newGlobalSuffixes);
    }

    protected boolean addSuffixesUnchecked(Collection<? extends Word<I>> newSuffixes) {
        int oldSize = this.hypothesis.size();
        for (Word<I> suf : newSuffixes) {
            if (this.splitters.contains(suf)) continue;
            this.splitters.add(suf);
            log.log(Level.FINE, "added suffix: {0}", suf);
        }
        this.startLearning();
        return this.hypothesis.size() != oldSize;
    }

    private static class QueueElement<I, O> {
        private Integer parentState;
        private QueueElement<I, O> parentElement;
        private I transIn;
        private O transOut;
        private int depth;

        private QueueElement(Integer parentState, QueueElement<I, O> parentElement, I transIn, O transOut) {
            this.parentState = parentState;
            this.parentElement = parentElement;
            this.transIn = transIn;
            this.transOut = transOut;
            this.depth = parentElement != null ? parentElement.depth + 1 : 0;
        }
    }

    public static class BuilderDefaults {
        public static <I, O> GlobalSuffixFinder<? super I, ? super Word<O>> suffixFinder() {
            return GlobalSuffixFinders.RIVEST_SCHAPIRE;
        }

        public static <I, O> Collection<? extends Word<I>> initialSplitters() {
            return null;
        }
    }
}

