/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.pta.pta;

import com.google.common.collect.Sets;
import de.learnlib.datastructure.pta.pta.AbstractBasePTAState;
import de.learnlib.datastructure.pta.pta.AbstractBlueFringePTA;
import de.learnlib.datastructure.pta.pta.AbstractBlueFringePTAState;
import de.learnlib.datastructure.pta.pta.PTATransition;
import java.awt.Color;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.commons.smartcollections.ArrayStorage;
import net.automatalib.commons.util.Pair;

public class RedBlueMerge<SP, TP, S extends AbstractBlueFringePTAState<SP, TP, S>> {
    private final AbstractBlueFringePTA<SP, TP, S> pta;
    private final ArrayStorage<ArrayStorage<S>> succMod;
    private final ArrayStorage<ArrayStorage<TP>> transPropMod;
    private final ArrayStorage<SP> propMod;
    private final int alphabetSize;
    private final S qr;
    private final S qb;
    private boolean merged;

    public RedBlueMerge(AbstractBlueFringePTA<SP, TP, S> pta, S qr, S qb) {
        if (!((AbstractBlueFringePTAState)qr).isRed()) {
            throw new IllegalArgumentException("Merge target must be a red state");
        }
        if (!((AbstractBlueFringePTAState)qb).isBlue()) {
            throw new IllegalArgumentException("Merge source must be a blue state");
        }
        this.pta = pta;
        int numRedStates = pta.getNumRedStates();
        this.succMod = new ArrayStorage(numRedStates);
        this.transPropMod = new ArrayStorage(numRedStates);
        this.propMod = new ArrayStorage(numRedStates);
        this.alphabetSize = pta.alphabetSize;
        this.qr = qr;
        this.qb = qb;
    }

    public S getRedState() {
        return this.qr;
    }

    public S getBlueState() {
        return this.qb;
    }

    public boolean merge() {
        FoldRecord curr;
        this.merged = true;
        if (!this.mergeRedProperties(this.qr, this.qb)) {
            return false;
        }
        this.updateRedTransition(((AbstractBlueFringePTAState)this.qb).parent, ((AbstractBlueFringePTAState)this.qb).parentInput, this.qr);
        ArrayDeque<FoldRecord<S>> stack = new ArrayDeque<FoldRecord<S>>();
        stack.push(new FoldRecord<S>(this.qr, this.qb));
        while ((curr = (FoldRecord)stack.peek()) != null) {
            int i;
            if ((i = ++curr.i) == this.alphabetSize) {
                stack.pop();
                continue;
            }
            AbstractBlueFringePTAState q = curr.q;
            Object r = curr.r;
            AbstractBlueFringePTAState rSucc = (AbstractBlueFringePTAState)((AbstractBasePTAState)r).getSuccessor(i);
            if (rSucc == null) continue;
            Object qSucc = this.getSucc(q, i);
            if (qSucc != null) {
                if (((AbstractBlueFringePTAState)qSucc).isRed()) {
                    if (!this.mergeRedProperties(qSucc, rSucc)) {
                        return false;
                    }
                } else {
                    Object rSuccSP = rSucc.property;
                    Object qSuccSP = ((AbstractBlueFringePTAState)qSucc).property;
                    Object newSP = null;
                    if (qSuccSP == null && rSuccSP != null) {
                        newSP = rSuccSP;
                    } else if (rSuccSP != null && !Objects.equals(qSuccSP, rSuccSP)) {
                        return false;
                    }
                    ArrayStorage<TP> newTPs = null;
                    ArrayStorage rSuccTPs = rSucc.transProperties;
                    ArrayStorage qSuccTPs = ((AbstractBlueFringePTAState)qSucc).transProperties;
                    if (rSuccTPs != null) {
                        if (qSuccTPs != null) {
                            ArrayStorage<TP> mergedTPs = this.mergeTransProperties(qSuccTPs, rSuccTPs);
                            if (mergedTPs == null) {
                                return false;
                            }
                            if (mergedTPs != qSuccTPs) {
                                newTPs = mergedTPs;
                            }
                        } else {
                            newTPs = rSuccTPs.clone();
                        }
                    }
                    if (newSP != null || newTPs != null) {
                        qSucc = this.cloneTopSucc(qSucc, i, stack, newTPs);
                        if (newSP != null) {
                            ((AbstractBlueFringePTAState)qSucc).property = newSP;
                        }
                    }
                }
                stack.push(new FoldRecord<AbstractBlueFringePTAState>((AbstractBlueFringePTAState)qSucc, rSucc));
                continue;
            }
            if (q.isRed()) {
                this.updateRedTransition(q, i, rSucc, ((AbstractBasePTAState)r).getTransProperty(i));
                continue;
            }
            q = this.cloneTop(q, stack);
            assert (q.isCopy);
            q.setForeignSuccessor(i, (AbstractBlueFringePTAState)rSucc, this.alphabetSize);
        }
        return true;
    }

    private S cloneTopSucc(S succ, int i, Deque<FoldRecord<S>> stack, ArrayStorage<TP> newTPs) {
        AbstractBasePTAState succClone;
        AbstractBasePTAState abstractBasePTAState = succClone = newTPs != null ? (AbstractBlueFringePTAState)((AbstractBasePTAState)succ).copy(newTPs) : ((AbstractBlueFringePTAState)succ).copy();
        if (succClone == succ) {
            return succ;
        }
        Object top = stack.peek().q;
        if (((AbstractBlueFringePTAState)top).isRed()) {
            this.updateRedTransition(top, i, succClone);
        } else {
            AbstractBasePTAState topClone = this.cloneTop(top, stack);
            ((AbstractBlueFringePTAState)topClone).setForeignSuccessor(i, (AbstractBasePTAState)succClone, this.alphabetSize);
        }
        return (S)succClone;
    }

    private S cloneTop(S topState, Deque<FoldRecord<S>> stack) {
        assert (!((AbstractBlueFringePTAState)topState).isRed());
        AbstractBasePTAState topClone = ((AbstractBlueFringePTAState)topState).copy();
        if (topClone == topState) {
            return topState;
        }
        AbstractBasePTAState currTgt = topClone;
        Iterator<FoldRecord<S>> it = stack.iterator();
        FoldRecord<S> currRec = it.next();
        assert (currRec.q == topState);
        currRec.q = topClone;
        assert (it.hasNext());
        currRec = it.next();
        Object currSrc = currRec.q;
        while (!((AbstractBlueFringePTAState)currSrc).isRed()) {
            AbstractBasePTAState currSrcClone = ((AbstractBlueFringePTAState)currSrc).copy();
            ((AbstractBlueFringePTAState)currSrcClone).successors.set(currRec.i, (Object)currTgt);
            if (currSrcClone == currSrc) {
                return (S)topClone;
            }
            currRec.q = currSrcClone;
            currTgt = currSrcClone;
            assert (it.hasNext());
            currRec = it.next();
            currSrc = currRec.q;
        }
        assert (((AbstractBlueFringePTAState)currSrc).isRed());
        this.updateRedTransition(currSrc, currRec.i, currTgt);
        return (S)topClone;
    }

    private ArrayStorage<TP> getTransProperties(S q) {
        int qId;
        ArrayStorage props;
        if (((AbstractBlueFringePTAState)q).isRed() && (props = (ArrayStorage)this.transPropMod.get(qId = ((AbstractBlueFringePTAState)q).id)) != null) {
            return props;
        }
        return ((AbstractBlueFringePTAState)q).transProperties;
    }

    private SP getStateProperty(S q) {
        int qId;
        Object prop;
        if (((AbstractBlueFringePTAState)q).isRed() && (prop = this.propMod.get(qId = ((AbstractBlueFringePTAState)q).id)) != null) {
            return (SP)prop;
        }
        return (SP)((AbstractBlueFringePTAState)q).property;
    }

    private S getSucc(S q, int i) {
        int qId;
        ArrayStorage modSuccs;
        if (((AbstractBlueFringePTAState)q).isRed() && (modSuccs = (ArrayStorage)this.succMod.get(qId = ((AbstractBlueFringePTAState)q).id)) != null) {
            return (S)((AbstractBlueFringePTAState)modSuccs.get(i));
        }
        return (S)((AbstractBlueFringePTAState)((AbstractBasePTAState)q).getSuccessor(i));
    }

    private void updateRedTransition(S redSrc, int input, S tgt) {
        this.updateRedTransition(redSrc, input, tgt, null);
    }

    private void updateRedTransition(S redSrc, int input, S tgt, TP transProp) {
        assert (((AbstractBlueFringePTAState)redSrc).isRed());
        int id = ((AbstractBlueFringePTAState)redSrc).id;
        ArrayStorage newSuccs = (ArrayStorage)this.succMod.get(id);
        if (newSuccs == null) {
            newSuccs = ((AbstractBlueFringePTAState)redSrc).successors == null ? new ArrayStorage(this.alphabetSize) : ((AbstractBlueFringePTAState)redSrc).successors.clone();
            this.succMod.set(id, (Object)newSuccs);
        }
        newSuccs.set(input, tgt);
        if (transProp != null) {
            ArrayStorage newTransProps = (ArrayStorage)this.transPropMod.get(id);
            if (newTransProps == null) {
                newTransProps = ((AbstractBlueFringePTAState)redSrc).transProperties == null ? new ArrayStorage(this.alphabetSize) : ((AbstractBlueFringePTAState)redSrc).transProperties.clone();
                this.transPropMod.set(id, (Object)newTransProps);
            }
            newTransProps.set(input, transProp);
        }
    }

    private boolean mergeRedProperties(S qr, S qb) {
        return this.mergeRedStateProperty(qr, qb) && this.mergeRedTransProperties(qr, qb);
    }

    private boolean mergeRedTransProperties(S qr, S qb) {
        assert (((AbstractBlueFringePTAState)qr).isRed());
        ArrayStorage<TP> qbProps = ((AbstractBlueFringePTAState)qb).transProperties;
        if (qbProps == null) {
            return true;
        }
        ArrayStorage<TP> qrProps = this.getTransProperties(qr);
        ArrayStorage<TP> mergedProps = qbProps;
        if (qrProps != null && (mergedProps = this.mergeTransProperties(qrProps, qbProps)) == null) {
            return false;
        }
        if (mergedProps != qrProps) {
            this.transPropMod.set(((AbstractBlueFringePTAState)qr).id, mergedProps);
        }
        return true;
    }

    private boolean mergeRedStateProperty(S qr, S qb) {
        assert (((AbstractBlueFringePTAState)qr).isRed());
        Object qbProp = ((AbstractBlueFringePTAState)qb).property;
        if (qbProp == null) {
            return true;
        }
        SP qrProp = this.getStateProperty(qr);
        if (qrProp != null) {
            return Objects.equals(qbProp, qrProp);
        }
        this.propMod.set(((AbstractBlueFringePTAState)qr).id, qbProp);
        return true;
    }

    private ArrayStorage<TP> mergeTransProperties(ArrayStorage<TP> tps1, ArrayStorage<TP> tps2) {
        Object tp2;
        Object tp1;
        int i;
        int len = tps1.size();
        ArrayStorage tps1OrCopy = tps1;
        for (i = 0; i < len; ++i) {
            tp1 = tps1OrCopy.get(i);
            tp2 = tps2.get(i);
            if (tp2 == null) continue;
            if (tp1 != null) {
                if (Objects.equals(tp1, tp2)) continue;
                return null;
            }
            tps1OrCopy = tps1.clone();
            tps1OrCopy.set(i++, tp2);
            break;
        }
        while (i < len) {
            tp1 = tps1OrCopy.get(i);
            tp2 = tps2.get(i);
            if (tp2 != null) {
                if (tp1 != null) {
                    if (!Objects.equals(tp1, tp2)) {
                        return null;
                    }
                } else {
                    tps1OrCopy.set(i, tp2);
                }
            }
            ++i;
        }
        return tps1OrCopy;
    }

    public void apply(AbstractBlueFringePTA<SP, TP, S> pta, Consumer<? super PTATransition<S>> newFrontierConsumer) {
        int alphabetSize = pta.alphabetSize;
        for (int i = 0; i < this.succMod.size(); ++i) {
            ArrayStorage newTransProps;
            Object newProp;
            AbstractBlueFringePTAState redState = (AbstractBlueFringePTAState)pta.redStates.get(i);
            assert (redState.isRed());
            ArrayStorage newSuccs = (ArrayStorage)this.succMod.get(i);
            if (newSuccs != null) {
                int len = newSuccs.size();
                for (int j = 0; j < len; ++j) {
                    AbstractBlueFringePTAState newSucc = (AbstractBlueFringePTAState)newSuccs.get(j);
                    if (newSucc == null) continue;
                    redState.setForeignSuccessor(j, newSucc, alphabetSize);
                    Color c = newSucc.getColor();
                    if (c == Color.RED) continue;
                    newSucc.parent = redState;
                    newSucc.parentInput = j;
                    this.incorporate(newSucc);
                    if (c == Color.BLUE) continue;
                    newFrontierConsumer.accept(newSucc.makeBlue());
                }
            }
            if ((newProp = this.propMod.get(i)) != null) {
                redState.property = newProp;
            }
            if ((newTransProps = (ArrayStorage)this.transPropMod.get(i)) == null) continue;
            redState.transProperties = newTransProps;
        }
    }

    private void incorporate(S state) {
        AbstractBlueFringePTAState curr;
        if (!((AbstractBlueFringePTAState)state).isCopy) {
            return;
        }
        ((AbstractBlueFringePTAState)state).isCopy = false;
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.offer(state);
        while ((curr = (AbstractBlueFringePTAState)queue.poll()) != null) {
            ArrayStorage succs = curr.successors;
            if (succs == null) continue;
            for (int i = 0; i < this.alphabetSize; ++i) {
                AbstractBlueFringePTAState succ = (AbstractBlueFringePTAState)succs.get(i);
                if (succ == null) continue;
                succ.parent = curr;
                succ.parentInput = i;
                if (!succ.isCopy) continue;
                succ.isCopy = false;
                queue.offer(succ);
            }
        }
    }

    public UniversalDeterministicAutomaton<S, Integer, ?, SP, TP> toMergedAutomaton() {
        if (!this.merged) {
            throw new IllegalStateException("#merge has not been called yet");
        }
        return new UniversalDeterministicAutomaton<S, Integer, Pair<S, Integer>, SP, TP>(){
            private Set<S> states;

            public S getSuccessor(Pair<S, Integer> transition) {
                AbstractBlueFringePTAState source = (AbstractBlueFringePTAState)transition.getFirst();
                Integer input = (Integer)transition.getSecond();
                if (source.isRed() && RedBlueMerge.this.succMod.get(source.id) != null) {
                    return (AbstractBlueFringePTAState)((ArrayStorage)RedBlueMerge.this.succMod.get(source.id)).get(input.intValue());
                }
                return RedBlueMerge.this.pta.getSuccessor(source, input);
            }

            public SP getStateProperty(S state) {
                if (((AbstractBlueFringePTAState)state).isRed() && RedBlueMerge.this.propMod.get(((AbstractBlueFringePTAState)state).id) != null) {
                    return RedBlueMerge.this.propMod.get(((AbstractBlueFringePTAState)state).id);
                }
                return ((AbstractBasePTAState)state).getStateProperty();
            }

            public TP getTransitionProperty(Pair<S, Integer> transition) {
                AbstractBlueFringePTAState source = (AbstractBlueFringePTAState)transition.getFirst();
                Integer input = (Integer)transition.getSecond();
                if (source.isRed() && RedBlueMerge.this.transPropMod.get(source.id) != null) {
                    return ((ArrayStorage)RedBlueMerge.this.transPropMod.get(source.id)).get(input.intValue());
                }
                return source.transProperties.get(input.intValue());
            }

            public Pair<S, Integer> getTransition(S state, Integer input) {
                return Pair.of(state, (Object)input);
            }

            public Collection<S> getStates() {
                AbstractBlueFringePTAState iter;
                if (this.states != null) {
                    return this.states;
                }
                this.states = Sets.newHashSetWithExpectedSize((int)RedBlueMerge.this.pta.size());
                ArrayDeque<Object> discoverQueue = new ArrayDeque<Object>();
                discoverQueue.add(this.getInitialState());
                while ((iter = (AbstractBlueFringePTAState)discoverQueue.poll()) != null) {
                    this.states.add(iter);
                    for (int i = 0; i < RedBlueMerge.this.alphabetSize; ++i) {
                        AbstractBlueFringePTAState succ = (AbstractBlueFringePTAState)this.getSuccessor(iter, i);
                        if (succ == null || this.states.contains(succ)) continue;
                        discoverQueue.add(succ);
                    }
                }
                return this.states;
            }

            public S getInitialState() {
                return (AbstractBlueFringePTAState)RedBlueMerge.this.pta.getInitialState();
            }
        };
    }

    static final class FoldRecord<S extends AbstractBlueFringePTAState<?, ?, S>> {
        public final S r;
        public S q;
        public int i = -1;

        FoldRecord(S q, S r) {
            this.q = q;
            this.r = r;
        }
    }
}

