/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.pta.pta;

import de.learnlib.datastructure.pta.pta.AbstractBasePTAState;
import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PTATransition<S extends AbstractBasePTAState<?, ?, S>> {
    private final S source;
    private final int index;

    public PTATransition(@Nonnull S source, @Nonnegative int index) {
        this.source = (AbstractBasePTAState)Objects.requireNonNull(source);
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        this.index = index;
    }

    @Nonnull
    public S getSource() {
        return this.source;
    }

    @Nonnegative
    public int getIndex() {
        return this.index;
    }

    @Nullable
    public S getTarget() {
        return ((AbstractBasePTAState)this.source).getSuccessor(this.index);
    }
}

