/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.pta.pta;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import de.learnlib.datastructure.pta.pta.AbstractBasePTAState;
import de.learnlib.datastructure.pta.pta.PTATransition;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.automatalib.automata.MutableDeterministic;
import net.automatalib.automata.UniversalDeterministicAutomaton;
import net.automatalib.commons.util.Pair;
import net.automatalib.commons.util.functions.FunctionsUtil;
import net.automatalib.graphs.Graph;
import net.automatalib.util.automata.Automata;
import net.automatalib.visualization.DefaultVisualizationHelper;
import net.automatalib.visualization.VisualizationHelper;
import net.automatalib.words.Alphabet;

@ParametersAreNonnullByDefault
public class BasePTA<SP, TP, S extends AbstractBasePTAState<SP, TP, S>>
implements UniversalDeterministicAutomaton<S, Integer, PTATransition<S>, SP, TP> {
    @Nonnegative
    protected final int alphabetSize;
    @Nonnull
    protected final S root;

    public BasePTA(@Nonnegative int alphabetSize, S root) {
        this.alphabetSize = alphabetSize;
        this.root = (AbstractBasePTAState)Objects.requireNonNull(root);
    }

    @Nullable
    public S getState(int[] word) {
        S curr = this.root;
        int len = word.length;
        for (int i = 0; i < len && curr != null; curr = ((AbstractBasePTAState)curr).getSuccessor(word[i]), ++i) {
        }
        return curr;
    }

    public void addSample(int[] sample, SP lastProperty) {
        S target = this.getOrCreateState(sample);
        if (!((AbstractBasePTAState)target).tryMergeStateProperty(lastProperty)) {
            throw new IllegalStateException();
        }
    }

    @Nonnull
    public S getOrCreateState(int[] word) {
        S curr = this.root;
        for (int sym : word) {
            curr = ((AbstractBasePTAState)curr).getOrCreateSuccessor(sym, this.alphabetSize);
        }
        return curr;
    }

    public void addSampleWithStateProperties(int[] sample, List<? extends SP> lastStateProperties) {
        int sampleLen = sample.length;
        int skip = sampleLen + 1 - lastStateProperties.size();
        if (skip < 0) {
            throw new IllegalArgumentException();
        }
        S curr = this.getRoot();
        int i = 0;
        while (i < skip) {
            int sym = sample[i++];
            curr = ((AbstractBasePTAState)curr).getOrCreateSuccessor(sym, this.alphabetSize);
        }
        Iterator<SP> spIt = lastStateProperties.iterator();
        while (i < sampleLen) {
            if (!((AbstractBasePTAState)curr).tryMergeStateProperty(spIt.next())) {
                throw new IllegalArgumentException();
            }
            int sym = sample[i++];
            curr = ((AbstractBasePTAState)curr).getOrCreateSuccessor(sym, this.alphabetSize);
        }
        if (!((AbstractBasePTAState)curr).tryMergeStateProperty(spIt.next())) {
            throw new IllegalArgumentException();
        }
    }

    @Nonnull
    public S getRoot() {
        return this.root;
    }

    public void addSampleWithTransitionProperties(int[] sample, List<? extends TP> lastTransitionProperties) {
        int sampleLen = sample.length;
        int skip = sampleLen - lastTransitionProperties.size();
        if (skip < 0) {
            throw new IllegalArgumentException();
        }
        S curr = this.getRoot();
        int i = 0;
        while (i < skip) {
            int sym = sample[i++];
            curr = ((AbstractBasePTAState)curr).getOrCreateSuccessor(sym, this.alphabetSize);
        }
        Iterator<TP> tpIt = lastTransitionProperties.iterator();
        while (i < sampleLen) {
            int sym;
            if (!((AbstractBasePTAState)curr).tryMergeTransitionProperty(sym = sample[i++], this.alphabetSize, tpIt.next())) {
                throw new IllegalArgumentException();
            }
            curr = ((AbstractBasePTAState)curr).getOrCreateSuccessor(sym, this.alphabetSize);
        }
    }

    public <I> void toAutomaton(MutableDeterministic<?, I, ?, ? super SP, ? super TP> automaton, Alphabet<I> alphabet) {
        this.toAutomaton(automaton, alphabet, sp -> sp, tp -> tp);
    }

    public <S2, I, SP2, TP2> void toAutomaton(MutableDeterministic<S2, I, ?, ? super SP2, ? super TP2> automaton, Alphabet<I> alphabet, Function<? super SP, ? extends SP2> spExtractor, Function<? super TP, ? extends TP2> tpExtractor) {
        Pair curr;
        Function safeSPExtractor = FunctionsUtil.safeDefault(spExtractor);
        Function safeTPExtractor = FunctionsUtil.safeDefault(tpExtractor);
        HashMap resultStates = new HashMap();
        ArrayDeque<Pair> queue = new ArrayDeque<Pair>();
        Object initProp = safeSPExtractor.apply(((AbstractBasePTAState)this.root).getStateProperty());
        Object resultInit = automaton.addInitialState(initProp);
        queue.add(new Pair(this.root, resultInit));
        while ((curr = (Pair)queue.poll()) != null) {
            AbstractBasePTAState ptaState = (AbstractBasePTAState)curr.getFirst();
            Object resultState = curr.getSecond();
            for (int i = 0; i < this.alphabetSize; ++i) {
                Object ptaSucc = ptaState.getSuccessor(i);
                if (ptaSucc == null) continue;
                Object resultSucc = resultStates.get(ptaSucc);
                if (resultSucc == null) {
                    Object prop = safeSPExtractor.apply(((AbstractBasePTAState)ptaSucc).getStateProperty());
                    resultSucc = automaton.addState(prop);
                    resultStates.put(ptaSucc, resultSucc);
                    queue.offer(new Pair(ptaSucc, resultSucc));
                }
                Object sym = alphabet.getSymbol(i);
                Object transProp = safeTPExtractor.apply(ptaState.getTransProperty(i));
                automaton.setTransition(resultState, sym, resultSucc, transProp);
            }
        }
        Automata.invasiveMinimize(automaton, alphabet);
    }

    public <I> Graph<S, PTATransition<S>> graphView(final Alphabet<I> alphabet) {
        return new Graph<S, PTATransition<S>>(){

            public Collection<PTATransition<S>> getOutgoingEdges(S node) {
                return IntStream.range(0, BasePTA.this.alphabetSize).filter(i -> node.getSuccessor(i) != null).mapToObj(i -> new PTATransition<AbstractBasePTAState>((AbstractBasePTAState)node, i)).collect(Collectors.toList());
            }

            public S getTarget(PTATransition<S> edge) {
                return edge.getTarget();
            }

            public Collection<S> getNodes() {
                return BasePTA.this.bfsStates();
            }

            public Iterator<S> iterator() {
                return BasePTA.this.bfsIterator();
            }

            public VisualizationHelper<S, PTATransition<S>> getVisualizationHelper() {
                return new DefaultVisualizationHelper<S, PTATransition<S>>(){

                    public boolean getEdgeProperties(S src, PTATransition<S> edge, S tgt, Map<String, String> properties) {
                        if (!super.getEdgeProperties(src, edge, tgt, properties)) {
                            return false;
                        }
                        properties.put("label", String.valueOf(alphabet.getSymbol(edge.getIndex())));
                        return true;
                    }
                };
            }
        };
    }

    @Nonnull
    public List<S> bfsStates() {
        ArrayList stateList = new ArrayList();
        HashSet visited = new HashSet();
        int ptr = 0;
        stateList.add(this.root);
        visited.add(this.root);
        int numStates = 1;
        while (ptr < numStates) {
            AbstractBasePTAState curr = (AbstractBasePTAState)stateList.get(ptr++);
            for (int i = 0; i < this.alphabetSize; ++i) {
                Object succ = curr.getSuccessor(i);
                if (succ == null || !visited.add(succ)) continue;
                stateList.add(succ);
                ++numStates;
            }
        }
        return stateList;
    }

    @Nonnull
    public Iterator<S> bfsIterator() {
        final HashSet<S> visited = new HashSet<S>();
        final ArrayDeque<S> bfsQueue = new ArrayDeque<S>();
        bfsQueue.add(this.root);
        visited.add(this.root);
        return new AbstractIterator<S>(){

            protected S computeNext() {
                AbstractBasePTAState next = (AbstractBasePTAState)bfsQueue.poll();
                if (next == null) {
                    return (AbstractBasePTAState)this.endOfData();
                }
                for (int i = 0; i < BasePTA.this.alphabetSize; ++i) {
                    Object child = next.getSuccessor(i);
                    if (child == null || !visited.add(child)) continue;
                    bfsQueue.offer(child);
                }
                return next;
            }
        };
    }

    public S getSuccessor(PTATransition<S> transition) {
        return transition.getTarget();
    }

    public S getSuccessor(S state, Integer input) {
        return ((AbstractBasePTAState)state).getSuccessor(input);
    }

    public Iterator<S> iterator() {
        return this.bfsIterator();
    }

    public Collection<S> getStates() {
        return this.bfsStates();
    }

    public int size() {
        return this.countStates();
    }

    @Nonnegative
    public int countStates() {
        return Iterators.size(this.bfsIterator());
    }

    public S getInitialState() {
        return this.getRoot();
    }

    public PTATransition<S> getTransition(S state, Integer input) {
        return new PTATransition<S>(state, input);
    }

    public SP getStateProperty(S state) {
        return ((AbstractBasePTAState)state).getStateProperty();
    }

    public TP getTransitionProperty(PTATransition<S> transition) {
        return ((AbstractBasePTAState)transition.getSource()).getTransProperty(transition.getIndex());
    }
}

