/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.pta.pta;

import de.learnlib.datastructure.pta.pta.AbstractBlueFringePTAState;
import de.learnlib.datastructure.pta.pta.BasePTA;
import de.learnlib.datastructure.pta.pta.PTATransition;
import de.learnlib.datastructure.pta.pta.RedBlueMerge;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public abstract class AbstractBlueFringePTA<SP, TP, S extends AbstractBlueFringePTAState<SP, TP, S>>
extends BasePTA<SP, TP, S> {
    @Nonnull
    protected final List<S> redStates = new ArrayList<S>();

    public AbstractBlueFringePTA(@Nonnegative int alphabetSize, S root) {
        super(alphabetSize, root);
    }

    public S getRedState(@Nonnegative int id) {
        return (S)((AbstractBlueFringePTAState)this.redStates.get(id));
    }

    @Nonnegative
    public int getNumRedStates() {
        return this.redStates.size();
    }

    public List<S> getRedStates() {
        return Collections.unmodifiableList(this.redStates);
    }

    public Stream<S> redStatesStream() {
        return this.redStates.stream();
    }

    public void init(Consumer<? super PTATransition<S>> newBlue) {
        ((AbstractBlueFringePTAState)this.root).color = Color.BLUE;
        this.promote((AbstractBlueFringePTAState)this.root, newBlue);
    }

    public void promote(S qb, Consumer<? super PTATransition<S>> newBlue) {
        this.makeRed(qb);
        qb.forEachSucc(s -> newBlue.accept(s.makeBlue()));
    }

    private void makeRed(S qb) {
        if (!((AbstractBlueFringePTAState)qb).isBlue()) {
            throw new IllegalArgumentException();
        }
        ((AbstractBlueFringePTAState)qb).makeRed(this.redStates.size());
        this.redStates.add(qb);
    }

    public RedBlueMerge<SP, TP, S> tryMerge(S qr, S qb) {
        RedBlueMerge merge = new RedBlueMerge(this, qr, qb);
        if (!merge.merge()) {
            return null;
        }
        return merge;
    }
}

