/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.pta.pta;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.automatalib.commons.util.array.RichArray;

public abstract class AbstractBasePTAState<SP, TP, S extends AbstractBasePTAState<SP, TP, S>>
implements Cloneable {
    protected SP property;
    protected RichArray<TP> transProperties;
    protected RichArray<S> successors;
    protected int id = -1;

    public SP getStateProperty() {
        return this.property;
    }

    public TP getTransProperty(int index) {
        if (this.transProperties == null) {
            return null;
        }
        return (TP)this.transProperties.get(index);
    }

    public S copy() {
        return this.copy(this.transProperties != null ? this.transProperties.clone() : null);
    }

    public S copy(RichArray<TP> newTPs) {
        try {
            AbstractBasePTAState copy = (AbstractBasePTAState)this.clone();
            copy.transProperties = newTPs;
            if (this.successors != null) {
                copy.successors = this.successors.clone();
            }
            return (S)copy;
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    public S getSuccessor(int index) {
        if (this.successors == null) {
            return null;
        }
        return (S)((AbstractBasePTAState)this.successors.get(index));
    }

    public void setSuccessor(int index, S succ, int alphabetSize) {
        if (this.successors == null) {
            this.successors = new RichArray(alphabetSize);
        }
        this.successors.update(index, succ);
    }

    public S getOrCreateSuccessor(int index, int alphabetSize) {
        AbstractBasePTAState<SP, TP, S> succ;
        if (this.successors == null) {
            this.successors = new RichArray(alphabetSize);
        }
        if ((succ = (AbstractBasePTAState)this.successors.get(index)) == null) {
            succ = this.createSuccessor(index);
            this.successors.update(index, (Object)succ);
        }
        return (S)succ;
    }

    protected S createSuccessor(int index) {
        return this.createState();
    }

    protected abstract S createState();

    public void forEachSucc(Consumer<? super S> cons) {
        if (this.successors != null) {
            for (AbstractBasePTAState succ : this.successors) {
                if (succ == null) continue;
                cons.accept(succ);
            }
        }
    }

    public void mergeTransitionProperty(int index, int alphabetSize, TP newTP) {
        if (!this.tryMergeTransitionProperty(index, alphabetSize, newTP)) {
            throw new IllegalArgumentException();
        }
    }

    public boolean tryMergeTransitionProperty(int index, int alphabetSize, TP newTP) {
        if (this.transProperties != null) {
            Object oldTp = this.transProperties.get(index);
            if (oldTp != null) {
                return Objects.equals(oldTp, newTP);
            }
        } else {
            this.transProperties = new RichArray(alphabetSize);
        }
        this.transProperties.update(index, newTP);
        return true;
    }

    public void mergeStateProperty(SP newSP) {
        if (!this.tryMergeStateProperty(newSP)) {
            throw new IllegalStateException();
        }
    }

    public boolean tryMergeStateProperty(SP newSP) {
        if (this.property != null) {
            return Objects.equals(this.property, newSP);
        }
        this.property = newSP;
        return true;
    }

    public Stream<S> successors() {
        if (this.successors == null) {
            return Stream.empty();
        }
        return this.successors.stream().filter(Objects::nonNull);
    }
}

