/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.pta.bluefringe;

import de.learnlib.datastructure.pta.bluefringe.ProcessingOrder;
import de.learnlib.datastructure.pta.pta.AbstractBlueFringePTAState;
import de.learnlib.datastructure.pta.pta.PTATransition;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.PriorityQueue;
import java.util.Queue;

public enum DefaultProcessingOrders implements ProcessingOrder
{
    CANONICAL_ORDER{

        @Override
        public <S extends AbstractBlueFringePTAState<?, ?, S>> Queue<PTATransition<S>> createWorklist() {
            return new PriorityQueue<PTATransition<S>>((t1, t2) -> {
                int cmp = ((AbstractBlueFringePTAState)t1.getSource()).compareTo((AbstractBlueFringePTAState)t2.getSource());
                if (cmp == 0) {
                    cmp = t1.getIndex() - t2.getIndex();
                }
                return cmp;
            });
        }
    }
    ,
    LEX_ORDER{

        @Override
        public <S extends AbstractBlueFringePTAState<?, ?, S>> Queue<PTATransition<S>> createWorklist() {
            return new PriorityQueue<PTATransition<S>>((t1, t2) -> {
                int cmp = ((AbstractBlueFringePTAState)t1.getSource()).lexCompareTo((AbstractBlueFringePTAState)t2.getSource());
                if (cmp == 0) {
                    cmp = t1.getIndex() - t2.getIndex();
                }
                return cmp;
            });
        }
    }
    ,
    FIFO_ORDER{

        @Override
        public <S extends AbstractBlueFringePTAState<?, ?, S>> Queue<PTATransition<S>> createWorklist() {
            return new ArrayDeque<PTATransition<S>>();
        }
    }
    ,
    LIFO_ORDER{

        @Override
        public <S extends AbstractBlueFringePTAState<?, ?, S>> Queue<PTATransition<S>> createWorklist() {
            return Collections.asLifoQueue(new ArrayDeque());
        }
    };

}

