/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.observationtable.writer;

import de.learnlib.datastructure.observationtable.ObservationTable;
import de.learnlib.datastructure.observationtable.writer.AbstractObservationTableWriter;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import net.automatalib.words.Word;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SuffixASCIIWriter<I, D>
extends AbstractObservationTableWriter<I, D> {
    private static final String WORD_DELIMITER = ";";
    private static final String SYMBOL_DELIMITER = ",";

    public SuffixASCIIWriter() {
        Function wordToString = new Function<Word<? extends I>, String>(){

            @Override
            public @Nullable String apply(@Nullable Word<? extends I> is) {
                if (is == null) {
                    return "";
                }
                boolean first = true;
                StringBuilder sb = new StringBuilder();
                for (Object symbol : is) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(SuffixASCIIWriter.SYMBOL_DELIMITER);
                    }
                    String stringRepresentation = symbol.toString();
                    if (stringRepresentation.contains(SuffixASCIIWriter.SYMBOL_DELIMITER) || stringRepresentation.contains(SuffixASCIIWriter.WORD_DELIMITER)) {
                        throw new IllegalArgumentException("Symbol '" + stringRepresentation + "' must not contain delimiters '" + SuffixASCIIWriter.SYMBOL_DELIMITER + "' or '" + SuffixASCIIWriter.WORD_DELIMITER + '\'');
                    }
                    sb.append(symbol.toString());
                }
                return sb.toString();
            }
        };
        super.setWordToString(wordToString);
    }

    @Override
    public void write(ObservationTable<? extends I, ? extends D> table, Appendable out) throws IOException {
        List<Word<I>> suffixes = table.getSuffixes();
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Word<I> word : suffixes) {
            if (first) {
                first = false;
            } else {
                sb.append(WORD_DELIMITER);
            }
            String stringRepresentation = this.wordToString(word);
            if (stringRepresentation.contains(WORD_DELIMITER)) {
                throw new IllegalArgumentException("Delimiter ';' must not be used in symbol names. Symbol containing the delimiter was '" + stringRepresentation + '\'');
            }
            sb.append(stringRepresentation);
        }
        out.append(sb.toString());
    }
}

