/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.observationtable.writer;

import de.learnlib.datastructure.observationtable.ObservationTable;
import de.learnlib.datastructure.observationtable.Row;
import de.learnlib.datastructure.observationtable.writer.AbstractObservationTableWriter;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import net.automatalib.words.Word;

public class ObservationTableHTMLWriter<I, D>
extends AbstractObservationTableWriter<I, D> {
    public ObservationTableHTMLWriter(Function<? super Word<? extends I>, ? extends String> wordToString, Function<? super D, ? extends String> outputToString) {
        super(wordToString, outputToString);
    }

    @Override
    public void write(ObservationTable<? extends I, ? extends D> table, Appendable out) throws IOException {
        this.writeInternal(table, this.wordToString, this.outputToString, out);
    }

    private <I, D> void writeInternal(ObservationTable<I, D> table, Function<? super Word<? extends I>, ? extends String> wordToString, Function<? super D, ? extends String> outputToString, Appendable out) throws IOException {
        List<Word<I>> suffixes = table.getSuffixes();
        out.append("<table class=\"learnlib-observationtable\">").append(System.lineSeparator());
        out.append("\t<thead>").append(System.lineSeparator());
        out.append("\t\t<tr><th rowspan=\"2\" class=\"prefix\">Prefix</th><th colspan=\"").append(Integer.toString(suffixes.size())).append("\" class=\"suffixes-header\">Suffixes</th></tr>").append(System.lineSeparator());
        out.append("\t\t<tr>");
        for (Word<I> word : suffixes) {
            out.append("<td>").append(wordToString.apply(word)).append("</td>");
        }
        out.append("</tr>").append(System.lineSeparator());
        out.append("\t</thead>").append(System.lineSeparator());
        out.append("\t<tbody>").append(System.lineSeparator());
        for (Row row : table.getShortPrefixRows()) {
            out.append("\t\t<tr class=\"short-prefix\"><td class=\"prefix\">").append(wordToString.apply(row.getLabel())).append("</td>");
            for (D value : table.rowContents(row)) {
                out.append("<td class=\"suffix-column\">").append(outputToString.apply(value)).append("</td>");
            }
            out.append("</tr>").append(System.lineSeparator());
        }
        out.append("\t\t<tr><td colspan=\"").append(Integer.toString(suffixes.size() + 1)).append("\"></td></tr>").append(System.lineSeparator());
        for (Row row : table.getLongPrefixRows()) {
            out.append("\t\t<tr class=\"long-prefix\"><td>").append(wordToString.apply(row.getLabel())).append("</td>");
            for (D value : table.rowContents(row)) {
                out.append("<td class=\"suffix-column\">").append(outputToString.apply(value)).append("</td>");
            }
            out.append("</tr>").append(System.lineSeparator());
        }
        out.append("</table>").append(System.lineSeparator());
    }
}

