/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.observationtable.writer;

import de.learnlib.datastructure.observationtable.ObservationTable;
import de.learnlib.datastructure.observationtable.Row;
import de.learnlib.datastructure.observationtable.writer.AbstractObservationTableWriter;
import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import net.automatalib.words.Word;

public class ObservationTableASCIIWriter<I, D>
extends AbstractObservationTableWriter<I, D> {
    private boolean rowSeparators;

    public ObservationTableASCIIWriter(Function<? super Word<? extends I>, ? extends String> wordToString, Function<? super D, ? extends String> outputToString, boolean rowSeparators) {
        super(wordToString, outputToString);
        this.rowSeparators = rowSeparators;
    }

    public ObservationTableASCIIWriter() {
        this(true);
    }

    public ObservationTableASCIIWriter(boolean rowSeparators) {
        this.rowSeparators = rowSeparators;
    }

    public void setRowSeparators(boolean rowSeparators) {
        this.rowSeparators = rowSeparators;
    }

    @Override
    public void write(ObservationTable<? extends I, ? extends D> table, Appendable out) throws IOException {
        this.writeInternal(table, this.wordToString, this.outputToString, out);
    }

    private <I, D> void writeInternal(ObservationTable<I, D> table, Function<? super Word<? extends I>, ? extends String> wordToString, Function<? super D, ? extends String> outputToString, Appendable out) throws IOException {
        List<Word<I>> suffixes = table.getSuffixes();
        int numSuffixes = suffixes.size();
        int[] colWidth = new int[numSuffixes + 1];
        int i = 1;
        for (Word<I> word : suffixes) {
            colWidth[i++] = wordToString.apply(word).length();
        }
        for (Row row : table.getAllRows()) {
            int n = wordToString.apply(row.getLabel()).length();
            if (n > colWidth[0]) {
                colWidth[0] = n;
            }
            i = 1;
            for (D value : table.rowContents(row)) {
                n = outputToString.apply(value).length();
                if (n > colWidth[i]) {
                    colWidth[i] = n;
                }
                ++i;
            }
        }
        ObservationTableASCIIWriter.appendSeparatorRow(out, '=', colWidth);
        String[] content = new String[numSuffixes + 1];
        content[0] = "";
        i = 1;
        for (Word<I> word : suffixes) {
            content[i++] = wordToString.apply(word);
        }
        ObservationTableASCIIWriter.appendContentRow(out, content, colWidth);
        ObservationTableASCIIWriter.appendSeparatorRow(out, '=', colWidth);
        boolean bl = true;
        for (Row<I> spRow : table.getShortPrefixRows()) {
            boolean bl2;
            if (bl2) {
                bl2 = false;
            } else if (this.rowSeparators) {
                ObservationTableASCIIWriter.appendSeparatorRow(out, '-', colWidth);
            }
            content[0] = wordToString.apply(spRow.getLabel());
            i = 1;
            for (D value : table.rowContents(spRow)) {
                content[i++] = outputToString.apply(value);
            }
            ObservationTableASCIIWriter.appendContentRow(out, content, colWidth);
        }
        ObservationTableASCIIWriter.appendSeparatorRow(out, '=', colWidth);
        boolean bl3 = true;
        for (Row<I> lpRow : table.getLongPrefixRows()) {
            boolean bl4;
            if (bl4) {
                bl4 = false;
            } else if (this.rowSeparators) {
                ObservationTableASCIIWriter.appendSeparatorRow(out, '-', colWidth);
            }
            content[0] = wordToString.apply(lpRow.getLabel());
            i = 1;
            for (D value : table.rowContents(lpRow)) {
                content[i++] = outputToString.apply(value);
            }
            ObservationTableASCIIWriter.appendContentRow(out, content, colWidth);
        }
        ObservationTableASCIIWriter.appendSeparatorRow(out, '=', colWidth);
    }

    private static void appendSeparatorRow(Appendable a, char sepChar, int[] colWidth) throws IOException {
        a.append('+').append(sepChar);
        ObservationTableASCIIWriter.appendRepeated(a, sepChar, colWidth[0]);
        for (int i = 1; i < colWidth.length; ++i) {
            a.append(sepChar).append('+').append(sepChar);
            ObservationTableASCIIWriter.appendRepeated(a, sepChar, colWidth[i]);
        }
        a.append(sepChar).append("+").append(System.lineSeparator());
    }

    private static void appendContentRow(Appendable a, String[] content, int[] colWidth) throws IOException {
        a.append("| ");
        ObservationTableASCIIWriter.appendRightPadded(a, content[0], colWidth[0]);
        for (int i = 1; i < content.length; ++i) {
            a.append(" | ");
            ObservationTableASCIIWriter.appendRightPadded(a, content[i], colWidth[i]);
        }
        a.append(" |").append(System.lineSeparator());
    }

    private static void appendRepeated(Appendable a, char c, int count) throws IOException {
        for (int i = 0; i < count; ++i) {
            a.append(c);
        }
    }

    private static void appendRightPadded(Appendable a, String string, int width) throws IOException {
        a.append(string);
        ObservationTableASCIIWriter.appendRepeated(a, ' ', width - string.length());
    }
}

