/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.observationtable.writer;

import de.learnlib.datastructure.observationtable.writer.ObservationTableWriter;
import java.util.Objects;
import java.util.function.Function;
import net.automatalib.words.Word;

public abstract class AbstractObservationTableWriter<I, D>
implements ObservationTableWriter<I, D> {
    protected Function<? super Word<? extends I>, ? extends String> wordToString;
    protected Function<? super D, ? extends String> outputToString;

    public AbstractObservationTableWriter() {
        this(Objects::toString, Objects::toString);
    }

    public AbstractObservationTableWriter(Function<? super Word<? extends I>, ? extends String> wordToString, Function<? super D, ? extends String> outputToString) {
        this.wordToString = AbstractObservationTableWriter.safeToStringFunction(wordToString);
        this.outputToString = AbstractObservationTableWriter.safeToStringFunction(outputToString);
    }

    protected static <T> Function<? super T, ? extends String> safeToStringFunction(Function<? super T, ? extends String> toStringFunction) {
        if (toStringFunction != null) {
            return toStringFunction;
        }
        return Objects::toString;
    }

    public void setWordToString(Function<? super Word<? extends I>, ? extends String> wordToString) {
        this.wordToString = AbstractObservationTableWriter.safeToStringFunction(wordToString);
    }

    public void setOutputToString(Function<? super D, ? extends String> outputToString) {
        this.outputToString = AbstractObservationTableWriter.safeToStringFunction(outputToString);
    }

    protected String wordToString(Word<? extends I> word) {
        return this.wordToString.apply(word);
    }

    protected String outputToString(D output) {
        return this.outputToString.apply(output);
    }
}

