/*
 * Decompiled with CFR 0.152.
 */
package de.learnlib.datastructure.observationtable;

import de.learnlib.api.oracle.MembershipOracle;
import de.learnlib.datastructure.observationtable.AbstractObservationTable;
import de.learnlib.datastructure.observationtable.Row;
import de.learnlib.datastructure.observationtable.RowImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.automatalib.automata.transducers.OutputAndLocalInputs;
import net.automatalib.words.GrowingAlphabet;
import net.automatalib.words.Word;
import net.automatalib.words.impl.SimpleAlphabet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PartialObservationTable<I, O>
extends AbstractObservationTable<I, Word<OutputAndLocalInputs<I, O>>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartialObservationTable.class);
    private final transient GrowingAlphabet<I> alphabet;
    private final transient Function<Word<I>, Collection<I>> enabledInputsProvider;
    private transient Consumer<I> newAlphabetNotifier;

    public PartialObservationTable(Consumer<I> newAlphabetNotifier, Function<Word<I>, Collection<I>> enabledInputsProvider) {
        this((GrowingAlphabet<I>)new SimpleAlphabet(), newAlphabetNotifier, enabledInputsProvider);
    }

    private PartialObservationTable(GrowingAlphabet<I> alphabet, Consumer<I> newAlphabetNotifier, Function<Word<I>, Collection<I>> enabledInputsProvider) {
        super(alphabet);
        this.alphabet = alphabet;
        this.newAlphabetNotifier = newAlphabetNotifier;
        this.enabledInputsProvider = enabledInputsProvider;
    }

    public void setNewAlphabetNotifier(Consumer<I> newAlphabetNotifier) {
        this.newAlphabetNotifier = newAlphabetNotifier;
    }

    @Override
    public List<List<Row<I>>> initialize(List<Word<I>> initialShortPrefixes, List<Word<I>> initialSuffixes, MembershipOracle<I, Word<OutputAndLocalInputs<I, O>>> oracle) {
        this.checkInitialShortPrefixes(initialShortPrefixes);
        ArrayList initialSuffixesWithEpsilon = new ArrayList(initialSuffixes.size() + 1);
        initialSuffixesWithEpsilon.add(Word.epsilon());
        initialSuffixesWithEpsilon.addAll(initialSuffixes);
        List suffixes = this.initializeSuffixes(initialSuffixesWithEpsilon);
        int numPrefixes = this.alphabet.size() * initialShortPrefixes.size() + 1;
        int numNonEmptySuffixes = suffixes.size() - 1;
        ArrayList queries = new ArrayList(numPrefixes * numNonEmptySuffixes);
        for (Word<I> word : initialShortPrefixes) {
            this.createSpRow(word);
            PartialObservationTable.buildQueries(queries, word, suffixes.subList(1, suffixes.size()));
        }
        oracle.processQueries(queries);
        Iterator queryIt = queries.iterator();
        for (RowImpl spRow : this.shortPrefixRows) {
            ArrayList<Word> rowContents = new ArrayList<Word>(numNonEmptySuffixes + 1);
            rowContents.add(Word.fromLetter((Object)new OutputAndLocalInputs(null, this.enabledInputsProvider.apply(spRow.getLabel()))));
            PartialObservationTable.fetchResults(queryIt, rowContents, numNonEmptySuffixes);
            if (this.processContents(spRow, rowContents, true)) continue;
            this.initialConsistencyCheckRequired = true;
        }
        queries.clear();
        for (RowImpl spRow : this.shortPrefixRows) {
            Word sp = spRow.getLabel();
            for (I sym : this.getEnabledInputs(spRow)) {
                this.checkForNewAlphabetSymbol(sym);
                Word lp = sp.append(sym);
                RowImpl succRow = this.getRow(lp);
                if (succRow == null) {
                    succRow = this.createLpRow(lp);
                    PartialObservationTable.buildQueries(queries, lp, suffixes.subList(1, suffixes.size()));
                }
                int i = this.alphabet.getSymbolIndex(sym);
                spRow.setSuccessor(i, succRow);
            }
        }
        oracle.processQueries(queries);
        queryIt = queries.iterator();
        int n = this.numberOfDistinctRows();
        ArrayList<List<Row<I>>> unclosed = new ArrayList<List<Row<I>>>();
        for (RowImpl spRow : this.shortPrefixRows) {
            for (int i = 0; i < this.alphabet.size(); ++i) {
                int id;
                Row succRow = spRow.getSuccessor(i);
                if (succRow == null || ((RowImpl)succRow).isShortPrefixRow()) continue;
                ArrayList<Word> rowContents = new ArrayList<Word>(numNonEmptySuffixes + 1);
                rowContents.add(Word.fromLetter((Object)new OutputAndLocalInputs(null, this.enabledInputsProvider.apply(((RowImpl)succRow).getLabel()))));
                PartialObservationTable.fetchResults(queryIt, rowContents, numNonEmptySuffixes);
                if (this.processContents(succRow, rowContents, false)) {
                    unclosed.add(new ArrayList());
                }
                if ((id = ((RowImpl)succRow).getRowContentId()) < n) continue;
                ((List)unclosed.get(id - n)).add(succRow);
            }
        }
        return unclosed;
    }

    @Override
    public List<List<Row<I>>> toShortPrefixes(List<Row<I>> lpRows, MembershipOracle<I, Word<OutputAndLocalInputs<I, O>>> oracle) {
        Row freshSpRow = null;
        ArrayList freshLpRows = new ArrayList();
        List suffixes = this.getSuffixes();
        int numNonEmptySuffixes = suffixes.size() - 1;
        for (Row<I> r : lpRows) {
            Row row = this.getRow(r.getRowId());
            if (((RowImpl)row).isShortPrefixRow()) {
                if (((RowImpl)row).hasContents()) continue;
                freshSpRow = row;
            } else {
                this.makeShort(row);
                if (!((RowImpl)row).hasContents()) {
                    freshSpRow = row;
                }
            }
            if (freshSpRow != null) {
                ArrayList queries = new ArrayList(numNonEmptySuffixes);
                PartialObservationTable.buildRowQueries(queries, Collections.singletonList(freshSpRow), suffixes.subList(1, suffixes.size()));
                oracle.processQueries(queries);
                Iterator queryIt = queries.iterator();
                ArrayList<Word> arrayList = new ArrayList<Word>(numNonEmptySuffixes + 1);
                arrayList.add(Word.fromLetter((Object)new OutputAndLocalInputs(null, this.enabledInputsProvider.apply(((RowImpl)freshSpRow).getLabel()))));
                PartialObservationTable.fetchResults(queryIt, arrayList, numNonEmptySuffixes);
                this.processContents(freshSpRow, arrayList, true);
            }
            Word prefix = ((RowImpl)row).getLabel();
            for (I i : this.getEnabledInputs((RowImpl<I>)row)) {
                this.checkForNewAlphabetSymbol(i);
                Word lp = prefix.append(i);
                RowImpl lpRow = this.getRow(lp);
                if (lpRow == null) {
                    lpRow = this.createLpRow(lp);
                    freshLpRows.add(lpRow);
                }
                int i2 = this.alphabet.getSymbolIndex(i);
                ((RowImpl)row).setSuccessor(i2, lpRow);
            }
        }
        ArrayList queries = new ArrayList(freshLpRows.size() * numNonEmptySuffixes);
        PartialObservationTable.buildRowQueries(queries, freshLpRows, suffixes.subList(1, suffixes.size()));
        oracle.processQueries(queries);
        Iterator queryIt = queries.iterator();
        int numSpRows = this.numberOfDistinctRows();
        ArrayList<List<Row<I>>> unclosed = new ArrayList<List<Row<I>>>();
        for (RowImpl rowImpl : freshLpRows) {
            int id;
            ArrayList<Word> contents = new ArrayList<Word>(numNonEmptySuffixes + 1);
            contents.add(Word.fromLetter((Object)new OutputAndLocalInputs(null, this.enabledInputsProvider.apply(rowImpl.getLabel()))));
            PartialObservationTable.fetchResults(queryIt, contents, numNonEmptySuffixes);
            if (this.processContents(rowImpl, contents, false)) {
                unclosed.add(new ArrayList());
            }
            if ((id = rowImpl.getRowContentId()) < numSpRows) continue;
            ((List)unclosed.get(id - numSpRows)).add(rowImpl);
        }
        return unclosed;
    }

    @Override
    public List<List<Row<I>>> addAlphabetSymbol(I symbol, MembershipOracle<I, Word<OutputAndLocalInputs<I, O>>> oracle) {
        LOGGER.info("Adding new symbols to a system, which already exposes its available actions has no effect");
        LOGGER.info("Skipping ...");
        return Collections.emptyList();
    }

    private void checkForNewAlphabetSymbol(I i) {
        if (!this.alphabet.containsSymbol(i)) {
            this.alphabet.addSymbol(i);
            int newAlphabetSize = this.alphabet.size();
            for (RowImpl prefix : this.shortPrefixRows) {
                prefix.ensureInputCapacity(newAlphabetSize);
            }
            this.newAlphabetNotifier.accept(i);
        }
    }

    private Collection<I> getEnabledInputs(RowImpl<I> row) {
        Word enabledInputs = (Word)this.cellContents(row, 0);
        return ((OutputAndLocalInputs)enabledInputs.getSymbol(0)).getLocalInputs();
    }
}

